<%--
  #%L
  %%
  Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>
<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp"%>
<%@ include file="/WEB-INF/jsp/kraExconTldHeader.jsp"%>

<c:set var="AssociatedDocumentAttributes" value="${DataDictionary.ExconProjectAssociatedDocument.attributes}" />
<c:set var="DocumentTypeAttributes" value="${DataDictionary.ExconProjectAssociatedDocumentType.attributes}" />

<c:set var="readOnly" value="${not KualiForm.editingMode['fullEntry']}" scope="request" />
<c:set var="action" value="exconProjectHome" />
<c:set var="returnsVals" value="${KualiForm.exconProjectAssociatedDocumentsBean.newAssociatedDocument.assocDocType.returnsVals}" />
<c:set var="assocDocIdAttr" value="${KualiForm.exconProjectAssociatedDocumentsBean.newAssociatedDocument.assocDocType.assocDocTypeNumberAttr}" />
<c:set var="assocDocLookupURL" value="${KualiForm.exconProjectAssociatedDocumentsBean.assocDocLookupURL}" />
<c:set var="isInternal" value="${!empty KualiForm.exconProjectAssociatedDocumentsBean.newAssociatedDocument.assocDocType.assocDocTypeClassName}" />
<c:if test="${not returnsVals}">
	<c:set var="lookupTarget" value="target='lookup'" />
</c:if>

<kul:tab tabTitle="Associated Documents" defaultOpen="true" tabErrorKey="exconProjectAssociatedDocumentsBean*" tabAuditKey="exconProjectAssociatedDocumentsBean*"
			auditCluster="associatedDocumentsAuditWarnings,associatedDocumentsAuditErrors" useRiceAuditMode="true">

	<div class="tab-container" align="center">
	<h3>
		<span class="subhead-left">&nbsp;</span>
		<span class="subhead-right"><kul:help businessObjectClassName="org.kuali.kra.excon.project.ExconProject" altText="help"/></span>
	</h3>
		<table cellpadding="0" cellspacing="0" summary="">
			<c:if test="${!readOnly}">
			<tr>
				<th class="infoline" colspan=6>
				<div align="center" valign="bottom">
				Add: 
				<kul:htmlControlAttribute property="exconProjectAssociatedDocumentsBean.newAssociatedDocument.assocDocTypeCode"
								attributeEntry="${AssociatedDocumentAttributes.assocDocTypeCode}"
								readOnly="${readOnly}" />
				<kul:kualiButton property="methodToCall.addAssociatedDocumentStub"
								 src="${ConfigProperties.kr.externalizable.images.url}tinybutton-add1.gif"
								 label="Add" title="Add Associated Document" styleClass="tinybutton addButton small outline" />
				</div>
				</th>
			</tr>
			</c:if>
			<tr>
				<th width="5%">&nbsp;</th>
				<th width="15%">Document Type</th>
				<th width="20%">Document Identifier</th>
				<th width="50%">Document Title</th>
				<th width="10%" style="text-align: center;">Actions</th>
			</tr>
			<c:if test="${!empty KualiForm.exconProjectAssociatedDocumentsBean.newAssociatedDocument.assocDocTypeCode}">
			<tbody class="addline">
			<tr>
				<td>&nbsp;</td>
				<td>
					${KualiForm.exconProjectAssociatedDocumentsBean.newAssociatedDocument.assocDocType.assocDocTypeName}
				</td>
				<td>
					${kfunc:registerEditableProperty(KualiForm, "exconProjectAssociatedDocumentsBean.newAssociatedDocument.assocDocNumber")}
					<kul:htmlControlAttribute property="exconProjectAssociatedDocumentsBean.newAssociatedDocument.assocDocNumber"
								attributeEntry="${AssociatedDocumentAttributes.assocDocNumber}"
								readOnly="${readOnly || returnsVals}" />
					<c:if test="${isInternal}">
								<kul:lookup boClassName="${KualiForm.exconProjectAssociatedDocumentsBean.newAssociatedDocument.assocDocType.assocDocTypeClassName}"
									fieldConversions="${assocDocIdAttr}:exconProjectAssociatedDocumentsBean.newAssociatedDocument.assocDocNumber,title:exconProjectAssociatedDocumentsBean.newAssociatedDocument.assocDocTitle"
									anchor="${tabKey}" />
					</c:if>
					<c:if test="${!empty assocDocLookupURL}">
						<a href="${assocDocLookupURL}" ${lookupTarget}>
							<img src='${ConfigProperties.kr.externalizable.images.url}searchicon.gif'>
						</a>
					</c:if>
					<input type="hidden" class="input.changed" value="true"/>
				</td>
				<td>
					<kul:htmlControlAttribute property="exconProjectAssociatedDocumentsBean.newAssociatedDocument.assocDocTitle"
								attributeEntry="${AssociatedDocumentAttributes.assocDocTitle}"
								readOnly="${readOnly || returnsVals}" />
				</td>
				<td colspan=2>
				<div align="center">
					<kul:kualiButton property="methodToCall.addAssociatedDocument"
									 src="${ConfigProperties.kr.externalizable.images.url}tinybutton-add1.gif"
									 label="Add" title="Add Associated Document" styleClass="tinybutton small outline" />
					<kul:kualiButton property="methodToCall.deleteAssociatedDocumentStub"
									 src="${ConfigProperties.kr.externalizable.images.url}tinybutton-reset1.gif"
									 label="Reset" title="Reset Associated Document" styleClass="tinybutton small outline" />
				</div>
				</td>
			</tr>
			</tbody>
			</c:if>
			<c:forEach var="associatedDocument"
				items="${KualiForm.exconProjectAssociatedDocumentsBean.exconProjectAssociatedDocuments}"
				varStatus="associatedDocumentRowStatus">
				<tr>
					<th class="infoline" scope="row"><c:out
							value="${associatedDocumentRowStatus.index + 1}" /></th>
					<td valign="middle">${associatedDocument.assocDocType.assocDocTypeName}</td>
					<td valign="middle">${associatedDocument.assocDocNumber}</td>
					<td valign="middle">${associatedDocument.assocDocTitle}</td>
					<td width="10%" style="text-align: center; min-width: 120px;">
							<c:if test="${!empty associatedDocument.assocDocViewURL}">
								<kul:kualiButton property="methodToCall.refresh"
												 src="${ConfigProperties.kra.externalizable.images.url}tinybutton-view.gif" label="View"
												 title="View ${associatedDocument.assocDocType.assocDocTypeName} #${associatedDocument.assocDocNumber}"
												 styleClass="tinybutton small outline"
												 onclick="window.open('${associatedDocument.assocDocViewURL}', '_blank'); return false;" />
							</c:if>
							<c:if test="${!readOnly}">
								<kul:kualiButton property="methodToCall.deleteAssociatedDocument.line${associatedDocumentRowStatus.index}.anchor${currentTabIndex}"
												 src="${ConfigProperties.kra.externalizable.images.url}tinybutton-delete1.gif"
												 label="Delete" title="Delete Associated Document" styleClass="tinybutton small outline" />
							</c:if>
					</td>
				</tr>
			</c:forEach>

		</table>
	</div>
</kul:tab>
