/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

var RiceContrib = RiceContrib || {};
RiceContrib.MultiSelect = RiceContrib.MultiSelect || {};
(function(namespace, $) {
	namespace.init = function() {
		$('.selectpicker').selectpicker('refresh');
		$('select.advanced_select').each(function() {
			if (!$(this).data().selectpicker) {
				var template = $(this).data('template');
				var defaultSettings = {
					selectedTextFormat : "count > 5",
					liveSearch : $(this).attr('multiple') ? true : false
				};
				
				$(this).selectpicker($.extend({}, defaultSettings, template));

				const id = 'results_' + Math.random().toString(36).substring(7);
				const label = jQuery(this).attr('aria-label');
				const multiselect = jQuery(this).siblings()[0];
				const button = jQuery(multiselect).find('button');
				button.attr('role', 'combobox');
				button.attr('aria-label', label);
				button.attr('aria-haspopup', 'true');

				let searchInput = jQuery(multiselect).find('input');
				searchInput.attr('role', 'combobox');
				searchInput.attr('aria-owns', id);

				let ul = jQuery(multiselect).find('ul');
				ul.attr('role', 'combobox');
				ul.attr('id', id)

				let elements = jQuery(multiselect).find('li');
				elements.attr('role', 'option');

				const selectpicker = $(this).data().selectpicker;
				if (!selectpicker.$button.attr('aria-label')) {
					const ariaLabel = $(`label[for="${this.id}"]`).text();
					if (ariaLabel) {
						selectpicker.$button.attr('aria-label', ariaLabel);
					}
				}

				// NOTE: implicit dependency on jquery-ui.${version}.css from kc-rice (ui-helper-hidden-accessible class)
				const $liveRegion = $('<div></div>', { class: 'ui-helper-hidden-accessible', role: 'status', 'aria-live': 'polite' }).insertAfter(this);
				selectpicker.$button.one('focus', function() {
					$liveRegion.text('Type to filter choices, use the up and down arrow keys to navigate the options, then use enter to select an option.');
				});
				selectpicker.$searchbox.on('input.multiselect propertychange.multiselect', function() {
					const searchValue = selectpicker.$searchbox.val();
					if (searchValue) {
						const searchMatch = selectpicker.selectpicker.search.elements;
						if (!searchMatch.length) {
							const escaped = $('<span></span>').text(searchValue).html();
							$liveRegion.html(selectpicker.options.noneResultsText.replace('{0}', '"' + escaped + '"'));
						}
					}
				});
			}
		});
	};
})(RiceContrib.MultiSelect, jQuery);

jQuery(document).ready(function() {
    RiceContrib.MultiSelect.init();
    jQuery("[data-role='View']").on(kradVariables.EVENTS.UPDATE_CONTENT, RiceContrib.MultiSelect.init);
    jQuery("[data-role='View']").on(kradVariables.EVENTS.SHOW_MODAL, RiceContrib.MultiSelect.init);
});
