<%--
  #%L
  %%
  Copyright (C) 2005 - 2019 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp"%>


<c:set var="protocolExceptions" value="${KualiForm.document.protocol.iacucProtocolExceptions}" />
<c:set var="protocolExceptionAttributes" value="${DataDictionary.IacucProtocolException.attributes}" />

<kul:documentPage
	showDocumentInfo="true"
	htmlFormAction="iacucProtocolException"
	documentTypeName="IacucProtocolDocument"
	renderMultipart="true"
	showTabButtons="true"
	auditCount="0"
  	headerDispatch="${KualiForm.headerDispatch}"
  	headerTabActive="protocolException">

  	<div align="right">
		<kra:shortUrl shortUrl="${KualiForm.shortUrl}"/>
		<kul:help documentTypeName="${KualiForm.docTypeName}" pageName="Protocol Exception" />
	</div>
  	
	<div id="workarea">
		<kra-iacuc:protocolException businessObjectClassName="org.kuali.kra.iacuc.species.exception.IacucProtocolException"
		                            protocolExceptionAttributes="${protocolExceptionAttributes}"
		                            collectionReference="${protocolExceptions}"
		                            collectionProperty="document.protocolList[0].iacucProtocolExceptions"
		                            action="iacucProtocolException" />
		<kul:panelFooter />
	</div>


	<script type="text/javascript">
	   var $j = jQuery.noConflict();
	</script>
	
	<SCRIPT type="text/javascript">
	var kualiForm = document.forms['KualiForm'];
	var kualiElements = kualiForm.elements;
	</SCRIPT>
	<script language="javascript" src="scripts/kuali_application.js"></script>

	<kul:documentControls transactionalDocument="false" suppressRoutingControls="true" />
</kul:documentPage>
