<#--
 #%L
 %%
 Copyright (C) 2005 - 2019 Kuali, Inc. - All Rights Reserved
 %%
 You may use and modify this code under the terms of the Kuali, Inc.
 Pre-Release License Agreement. You may not distribute it.
 
 You should have received a copy of the Kuali, Inc. Pre-Release License
 Agreement with this file. If not, please write to license@kuali.co.
 #L%
-->

<#include "libInclude.ftl" parse=true/>

<#compress>

    <#global view=KualiForm.view!/>

    <#if KualiForm.ajaxRequest && KualiForm.ajaxReturnType == "redirect">
        <div data-returntype="redirect">
            <#include "redirect.ftl" parse=true/>
        </div>
    <#elseif view?? && view.viewTemplates??>
        <#-- include all templates needed for the view -->
        <#list view.viewTemplates as viewTemplate>
            <#include "${viewTemplate}" parse=true/>
        </#list>
    </#if>

    <#if KualiForm.jsonRequest>
        <#include "${KualiForm.requestJsonTemplate}" parse=true/>
    <#elseif KualiForm.ajaxRequest>

        <#if KualiForm.ajaxReturnType == "update-view">
            <div data-returntype="update-view">
                <#include "fullView.ftl" parse=true/>
            </div>

        <#elseif KualiForm.ajaxReturnType == "update-component">
            <div data-returntype="update-component" data-id="${KualiForm.updateComponentId!}">
                <#include "updateComponent.ftl" parse=true/>
            </div>

        <#elseif KualiForm.ajaxReturnType == "update-page">
            <div data-returntype="update-page">
                <#include "updatePage.ftl" parse=true/>
            </div>
            <div data-returntype="update-form">
                ${KualiForm.formPostUrl}
            </div>

        <#elseif KualiForm.ajaxReturnType == "display-lightbox">
            <div data-returntype="display-lightbox">
                <#include "updateComponent.ftl" parse=true/>
            </div>

        <#elseif KualiForm.ajaxReturnType == "update-dialog">
            <div data-returntype="update-dialog" data-updatecomponentid="${KualiForm.updateComponentId!}">
                <#include "updateDialog.ftl" parse=true/>
            </div>
        </#if>

    <#else>
        <#include "fullView.ftl" parse=true/>
    </#if>

</#compress>
