/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.common;

import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;

public class Extractor {
    public void handleMajorVersion(AbstractMojo mojo, MavenProject project, String property) {
        String majorVersion = this.getMajorVersion(project.getVersion());
        if (!StringUtils.isEmpty((String)majorVersion)) {
            project.getProperties().setProperty(property, majorVersion);
            mojo.getLog().debug((CharSequence)("Setting project property: " + property + "=" + majorVersion));
        } else {
            mojo.getLog().debug((CharSequence)"Major version could not be determined");
        }
    }

    public void handleScmUrl(AbstractMojo mojo, MavenProject project, String property) {
        String scmUrl = this.getScmUrl(project.getScm());
        if (!StringUtils.isEmpty((String)scmUrl)) {
            project.getProperties().setProperty(property, scmUrl);
            mojo.getLog().debug((CharSequence)("Setting project property: " + property + "=" + scmUrl));
        } else {
            mojo.getLog().debug((CharSequence)"scm url could not be determined");
        }
    }

    public void handleScmType(AbstractMojo mojo, MavenProject project, String property) {
        String scmType = this.getScmType(project.getScm());
        if (!StringUtils.isEmpty((String)scmType)) {
            project.getProperties().setProperty(property, scmType);
            mojo.getLog().debug((CharSequence)("Setting project property: " + property + "=" + scmType));
        } else {
            mojo.getLog().debug((CharSequence)"scm type could not be determined");
        }
    }

    public String getScmUrl(Scm scm) {
        String scmUrl;
        String devCon = scm.getDeveloperConnection();
        String con = scm.getDeveloperConnection();
        String string = scmUrl = StringUtils.isEmpty((String)devCon) ? con : devCon;
        if (StringUtils.isEmpty((String)scmUrl)) {
            return null;
        }
        String[] tokens = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)scmUrl, (String)":");
        if (tokens == null || tokens.length < 3) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 2; i < tokens.length; ++i) {
            if (i != 2) {
                sb.append(":");
            }
            sb.append(tokens[i]);
        }
        return sb.toString();
    }

    public String getScmType(Scm scm) {
        String scmType1 = this.getScmType(scm.getDeveloperConnection());
        String scmType2 = this.getScmType(scm.getConnection());
        if (!StringUtils.isEmpty((String)scmType1)) {
            return scmType1;
        }
        if (!StringUtils.isEmpty((String)scmType2)) {
            return scmType2;
        }
        return null;
    }

    public String getScmType(String url) {
        if (StringUtils.isEmpty((String)url)) {
            return null;
        }
        String[] tokens = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)url, (String)":");
        if (tokens == null || tokens.length < 2) {
            return null;
        }
        return tokens[1];
    }

    public String getMajorVersion(String version) {
        if (StringUtils.isEmpty((String)version)) {
            return null;
        }
        int pos = this.getPos(version);
        if (pos == -1) {
            return version;
        }
        int peekAhead = this.peekAhead(pos, version);
        return version.substring(0, peekAhead);
    }

    protected int peekAhead(int pos, String version) {
        int index = pos + 1;
        if (index >= version.length()) {
            return pos;
        }
        char c = version.charAt(index);
        if (this.isInteger(c)) {
            return index + 1;
        }
        return pos;
    }

    protected int getPos(String version) {
        int pos2;
        int pos1 = version.indexOf(".");
        if (pos1 == (pos2 = version.indexOf("-")) && pos2 == -1) {
            return -1;
        }
        if (pos1 == -1 && pos2 != -1) {
            return pos2;
        }
        if (pos1 != -1 && pos2 == -1) {
            return pos1;
        }
        return Math.min(pos1, pos2);
    }

    protected boolean isInteger(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }
}

