/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.externals;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.kuali.maven.plugins.externals.SVNExternal;
import org.kuali.maven.plugins.externals.SVNUtils;
import org.tmatesoft.svn.core.SVNCommitInfo;

public class CommitMojo
extends AbstractMojo {
    SVNUtils svnUtils = SVNUtils.getInstance();
    private String commitMessage;
    private MavenProject project;
    private File workingCopy;

    public void execute() throws MojoExecutionException {
        ArrayList<File> dirs = new ArrayList<File>();
        dirs.add(this.workingCopy);
        List<SVNExternal> externals = this.svnUtils.getExternals(this.workingCopy);
        for (SVNExternal external : externals) {
            File dir = new File(this.workingCopy.getAbsolutePath() + File.separator + external.getPath());
            if (!dir.exists()) {
                this.getLog().warn((CharSequence)(dir.getAbsolutePath() + " does not exist"));
                continue;
            }
            dirs.add(dir);
        }
        this.getLog().info((CharSequence)"Committing changes in:");
        for (File dir : dirs) {
            this.getLog().info((CharSequence)dir.getAbsolutePath());
        }
        SVNCommitInfo info = this.svnUtils.commit(dirs, this.commitMessage, null, null);
        long newRevision = info.getNewRevision();
        if (newRevision == -1L) {
            this.getLog().info((CharSequence)"No changes detected.");
        } else {
            this.getLog().info((CharSequence)("Committed revision " + info.getNewRevision() + "."));
        }
    }

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public void setCommitMessage(String commitMessage) {
        this.commitMessage = commitMessage;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public File getWorkingCopy() {
        return this.workingCopy;
    }

    public void setWorkingCopy(File workingCopy) {
        this.workingCopy = workingCopy;
    }
}

