/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.externals;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.kuali.maven.plugins.externals.SVNUtils;
import org.kuali.maven.plugins.externals.SimpleScanner;
import org.tmatesoft.svn.core.SVNCommitInfo;

public class DirSyncMojo
extends AbstractMojo {
    SVNUtils svnUtils = SVNUtils.getInstance();
    private MavenProject project;
    private String commitMessage;
    private File newDir;
    private File oldDir;
    private String includes;
    private String excludes;

    public void execute() throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)"Syncing directories");
            this.getLog().info((CharSequence)("New Dir - " + this.newDir.getCanonicalPath()));
            this.getLog().info((CharSequence)("Old Dir - " + this.oldDir.getCanonicalPath()));
            this.getLog().info((CharSequence)("Include - " + this.includes));
            this.getLog().info((CharSequence)("Exclude - " + this.excludes));
            List<File> oldFiles = this.getFiles(this.oldDir, this.includes, this.excludes);
            List<File> newFiles = this.getFiles(this.newDir, this.includes, this.excludes);
            List<File> deletes = this.getDeletableFiles(this.newDir, this.oldDir, newFiles, oldFiles);
            if (deletes.size() == 0) {
                this.getLog().info((CharSequence)"No files to delete.");
                return;
            }
            this.getLog().info((CharSequence)("Located - " + deletes.size() + " files to delete"));
            for (File delete : deletes) {
                this.getLog().info((CharSequence)("Deleting " + delete.getCanonicalPath()));
            }
            this.svnUtils.markForDeletion(deletes);
            SVNCommitInfo info = this.svnUtils.commit(this.oldDir, this.commitMessage, null, null);
            this.getLog().info((CharSequence)("Committed revision " + info.getNewRevision() + "."));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unexpected error", e);
        }
    }

    protected List<String> getRelativePaths(File dir, List<File> files) throws IOException {
        String path = dir.getCanonicalPath();
        ArrayList<String> paths = new ArrayList<String>();
        for (File file : files) {
            String filePath = file.getCanonicalPath();
            String s = StringUtils.remove((String)filePath, (String)path);
            paths.add(s);
        }
        return paths;
    }

    protected List<File> getDeletableFiles(File newDir, File oldDir, List<File> newFiles, List<File> oldFiles) throws IOException {
        List<String> newPaths = this.getRelativePaths(newDir, newFiles);
        List<String> oldPaths = this.getRelativePaths(oldDir, oldFiles);
        ArrayList<File> deletableFiles = new ArrayList<File>();
        for (int i = 0; i < oldPaths.size(); ++i) {
            String path = oldPaths.get(i);
            if (newPaths.contains(path)) continue;
            deletableFiles.add(oldFiles.get(i));
        }
        return deletableFiles;
    }

    protected List<File> getFiles(File dir, String includes, String excludes) {
        String[] includeTokens = StringUtils.split((String)includes, (String)",");
        String[] excludeTokens = StringUtils.split((String)excludes, (String)",");
        SimpleScanner scanner = new SimpleScanner(dir, includeTokens, excludeTokens);
        return scanner.getFiles();
    }

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public void setCommitMessage(String commitMessage) {
        this.commitMessage = commitMessage;
    }

    public File getOldDir() {
        return this.oldDir;
    }

    public void setOldDir(File oldDir) {
        this.oldDir = oldDir;
    }

    public File getNewDir() {
        return this.newDir;
    }

    public void setNewDir(File newDir) {
        this.newDir = newDir;
    }

    public String getIncludes() {
        return this.includes;
    }

    public void setIncludes(String include) {
        this.includes = include;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String exclude) {
        this.excludes = exclude;
    }

    public MavenProject getProject() {
        return this.project;
    }
}

