/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.externals;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.maven.plugins.externals.Copy;
import org.kuali.maven.plugins.externals.SVNExternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVNUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SVNUtils.class);
    private static final String EMPTY_STRING = "";
    private static final String EXTERNALS_PROPERTY_NAME = "svn:externals";
    private static final String EXTERNALS_COMMENT = "#";
    private static final String DELETE_EXTERNALS_COMMIT_MESSAGE = "Delete externals";
    private static final String CREATE_EXTERNALS_COMMIT_MESSAGE = "Create externals";
    private static final String LINEFEED = "\n";
    private static final String SPACE = " ";
    private static final String SEMICOLON = ":";
    protected static SVNUtils instance;

    protected SVNUtils() {
        this.initialize();
    }

    protected void initialize() {
        SVNRepositoryFactoryImpl.setup();
        DAVRepositoryFactory.setup();
        FSRepositoryFactory.setup();
    }

    public static synchronized SVNUtils getInstance() {
        if (instance == null) {
            instance = new SVNUtils();
        }
        return instance;
    }

    public void showExternals(List<SVNExternal> externals) {
        for (SVNExternal e : externals) {
            StringBuilder sb = new StringBuilder();
            sb.append("[" + e.getPath());
            sb.append(", " + e.getWorkingCopyPath());
            sb.append(", " + e.getUrl());
            sb.append("]");
            LOGGER.info(sb.toString());
        }
    }

    public SVNCommitInfo copy(String src, String dst) {
        return this.copy(src, null, dst, null);
    }

    public SVNCommitInfo copy(String src, String dst, String msg) {
        return this.copy(src, null, dst, msg);
    }

    public SVNCommitInfo copy(String src, Long revision, String dst) {
        return this.copy(src, revision, dst, null);
    }

    public SVNCommitInfo copy(String src, Long revision, String dst, String msg) {
        Copy copy = new Copy();
        copy.setSource(src);
        copy.setRevision(revision);
        copy.setDestination(dst);
        copy.setMessage(msg);
        return this.copy(copy);
    }

    public SVNCommitInfo setExternals(String url, List<SVNExternal> externals) {
        return this.setExternals(url, externals, null);
    }

    public SVNCommitInfo setExternals(String url, List<SVNExternal> externals, String message) {
        return this.setExternals(url, externals, message, null, null);
    }

    public SVNCommitInfo setExternals(String url, List<SVNExternal> externals, String message, String username, String password) {
        SVNClientManager manager = SVNClientManager.newInstance(null, (String)username, (String)password);
        SVNWCClient client = manager.getWCClient();
        String commitMessage = StringUtils.isBlank((String)message) ? CREATE_EXTERNALS_COMMIT_MESSAGE : message;
        SVNURL svnUrl = this.getSvnUrl(url);
        StringBuilder sb = new StringBuilder();
        for (SVNExternal external : externals) {
            sb.append(external.getPath() + SPACE + external.getUrl() + LINEFEED);
        }
        SVNPropertyValue value = SVNPropertyValue.create((String)sb.toString());
        try {
            return client.doSetProperty(svnUrl, EXTERNALS_PROPERTY_NAME, value, SVNRevision.HEAD, commitMessage, null, true, null);
        }
        catch (SVNException e) {
            throw new IllegalStateException(e);
        }
    }

    public SVNCommitInfo deleteExternals(String url) {
        return this.deleteExternals(url, null);
    }

    public SVNCommitInfo deleteExternals(String url, String message) {
        return this.deleteExternals(url, message, null, null);
    }

    public SVNCommitInfo deleteExternals(String url, String message, String username, String password) {
        SVNClientManager manager = SVNClientManager.newInstance(null, (String)username, (String)password);
        SVNWCClient client = manager.getWCClient();
        String commitMessage = StringUtils.isBlank((String)message) ? DELETE_EXTERNALS_COMMIT_MESSAGE : message;
        SVNURL svnUrl = this.getSvnUrl(url);
        try {
            return client.doSetProperty(svnUrl, EXTERNALS_PROPERTY_NAME, null, SVNRevision.HEAD, commitMessage, null, true, null);
        }
        catch (SVNException e) {
            throw new IllegalStateException(e);
        }
    }

    public void markForDeletion(List<File> files) {
        SVNWCClient client = this.getSVNWCClient();
        try {
            for (File file : files) {
                client.doDelete(file, true, false);
            }
        }
        catch (SVNException e) {
            throw new IllegalStateException(e);
        }
    }

    protected SVNURL[] getSvnUrlArray(List<File> files) {
        String singleSlashPrefix = "file:/";
        String doubleSlashPrefix = "file://";
        SVNURL[] array = new SVNURL[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            SVNURL fileUrl;
            File file = files.get(i);
            String fileUrlString = file.toURI().toString();
            boolean singleSlash = StringUtils.startsWith((String)fileUrlString, (String)singleSlashPrefix);
            boolean doubleSlash = StringUtils.startsWith((String)fileUrlString, (String)doubleSlashPrefix);
            if (singleSlash && !doubleSlash) {
                fileUrlString = StringUtils.replace((String)fileUrlString, (String)singleSlashPrefix, (String)doubleSlashPrefix);
            }
            array[i] = fileUrl = this.getSvnUrl(fileUrlString);
        }
        return array;
    }

    public void markForDeletion(File file) {
        this.markForDeletion(Collections.singletonList(file));
    }

    public SVNCommitInfo copy(Copy copy) {
        String msg;
        SVNClientManager manager = SVNClientManager.newInstance(null, (String)copy.getUsername(), (String)copy.getPassword());
        SVNCopyClient client = manager.getCopyClient();
        SVNURL dstUrl = this.getSvnUrl(copy.getDestination());
        SVNURL srcUrl = this.getSvnUrl(copy.getSource());
        SVNRevision revision = SVNRevision.HEAD;
        if (copy.getRevision() != null) {
            revision = SVNRevision.create((long)copy.getRevision());
        }
        if (StringUtils.isBlank((String)(msg = copy.getMessage()))) {
            String r = copy.getRevision() != null ? "@" + revision : EMPTY_STRING;
            msg = "Copy " + copy.getSource() + r + " to " + copy.getDestination();
        }
        SVNCopySource svnCopySource = new SVNCopySource(SVNRevision.HEAD, revision, srcUrl);
        SVNCopySource[] sources = new SVNCopySource[]{svnCopySource};
        try {
            return client.doCopy(sources, dstUrl, false, true, true, msg, null);
        }
        catch (SVNException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getUrl(File workingCopyPath) {
        SVNInfo info = this.getInfo(workingCopyPath);
        return info.getURL().toDecodedString();
    }

    public List<SVNExternal> getExternals(String url) {
        try {
            SVNWCClient client = this.getSVNWCClient();
            SVNURL svnUrl = this.getSvnUrl(url);
            SVNPropertyData data = client.doGetProperty(svnUrl, EXTERNALS_PROPERTY_NAME, SVNRevision.HEAD, SVNRevision.HEAD);
            return this.getExternals(data, null);
        }
        catch (SVNException e) {
            throw new IllegalStateException(e);
        }
    }

    public long checkout(String url, File dstPath, String username, String password) {
        try {
            SVNClientManager manager = SVNClientManager.newInstance(null, (String)username, (String)password);
            SVNUpdateClient client = manager.getUpdateClient();
            client.setIgnoreExternals(false);
            SVNURL svnUrl = this.getSvnUrl(url);
            return client.doCheckout(svnUrl, dstPath, SVNRevision.HEAD, SVNRevision.HEAD, SVNDepth.INFINITY, false);
        }
        catch (SVNException e) {
            throw new IllegalStateException(e);
        }
    }

    public SVNCommitInfo commit(List<File> workingCopyPaths, String message, String username, String password) {
        File[] fileArray = workingCopyPaths.toArray(new File[workingCopyPaths.size()]);
        return this.commit(fileArray, message, username, password);
    }

    public SVNCommitInfo commit(File[] workingCopyPaths, String message, String username, String password) {
        try {
            SVNClientManager manager = SVNClientManager.newInstance(null, (String)username, (String)password);
            SVNCommitClient client = manager.getCommitClient();
            client.setIgnoreExternals(false);
            return client.doCommit(workingCopyPaths, true, message, null, null, true, false, SVNDepth.INFINITY);
        }
        catch (SVNException e) {
            throw new IllegalStateException(e);
        }
    }

    public SVNCommitInfo commit(File workingCopyPath, String message, String username, String password) {
        return this.commit(new File[]{workingCopyPath}, message, username, password);
    }

    public List<SVNExternal> getExternals(File workingCopyPath) {
        try {
            SVNWCClient client = this.getSVNWCClient();
            SVNPropertyData data = client.doGetProperty(workingCopyPath, EXTERNALS_PROPERTY_NAME, SVNRevision.WORKING, SVNRevision.WORKING);
            return this.getExternals(data, workingCopyPath);
        }
        catch (SVNException e) {
            throw new IllegalStateException(e);
        }
    }

    public long getLastRevision(File workingCopyPath) {
        SVNInfo info = this.getInfo(workingCopyPath);
        return info.getCommittedRevision().getNumber();
    }

    public long getLastRevision(String url) {
        SVNRepository repository = this.getRepository(url);
        return this.getLastRevision(repository);
    }

    protected List<SVNExternal> getExternals(SVNPropertyData data, File workingCopyPath) {
        if (data == null) {
            return new ArrayList<SVNExternal>();
        }
        SVNPropertyValue value = data.getValue();
        String s = SVNPropertyValue.getPropertyAsString((SVNPropertyValue)value);
        String[] tokens = StringUtils.split((String)s, (String)LINEFEED);
        ArrayList<SVNExternal> externals = new ArrayList<SVNExternal>();
        for (String token : tokens) {
            if ((token = token.trim()).startsWith(EXTERNALS_COMMENT) || StringUtils.isBlank((String)token)) continue;
            String[] values = StringUtils.split((String)token, (String)SPACE);
            if (values.length != 2) {
                throw new IllegalStateException("Unparseable svn:externals definition - [" + token + ", " + workingCopyPath + "]");
            }
            String value1 = values[0];
            String value2 = values[1];
            String url = this.getUrl(value1, value2);
            String path = this.getPath(value1, value2);
            File externalsPath = this.getExternalWorkingCopyPath(workingCopyPath, path);
            SVNExternal external = new SVNExternal();
            external.setUrl(url);
            external.setPath(path);
            external.setWorkingCopyPath(externalsPath);
            externals.add(external);
        }
        return externals;
    }

    protected boolean isUrl(String s) {
        return s.contains(SEMICOLON);
    }

    protected String getUrl(String value1, String value2) {
        if (this.isUrl(value1)) {
            return value1;
        }
        return value2;
    }

    protected String getPath(String value1, String value2) {
        if (this.isUrl(value1)) {
            return value2;
        }
        return value1;
    }

    protected File getExternalWorkingCopyPath(File workingCopyPath, String path) {
        if (workingCopyPath == null) {
            return null;
        }
        return new File(workingCopyPath.getAbsolutePath() + File.separator + path);
    }

    protected SVNWCClient getSVNWCClient() {
        ISVNAuthenticationManager authMgr = SVNWCUtil.createDefaultAuthenticationManager();
        return new SVNWCClient(authMgr, null);
    }

    protected SVNInfo getInfo(File workingCopyPath) {
        try {
            SVNWCClient client = this.getSVNWCClient();
            SVNRevision revision = SVNRevision.create((long)-1L);
            return client.doInfo(workingCopyPath, revision);
        }
        catch (SVNException e) {
            throw new IllegalStateException(e);
        }
    }

    protected long getLastRevision(SVNRepository repository) {
        try {
            SVNDirEntry entry = repository.info(EMPTY_STRING, -1L);
            return entry.getRevision();
        }
        catch (SVNException e) {
            throw new IllegalStateException(e);
        }
    }

    protected SVNRepository getRepository(String url) {
        return this.getRepository(url, null, null);
    }

    protected SVNRepository getRepository(String url, String username, String password) {
        try {
            SVNURL svnUrl = this.getSvnUrl(url);
            SVNRepository repository = SVNRepositoryFactory.create((SVNURL)svnUrl, null);
            if (!StringUtils.isBlank((String)username) && !StringUtils.isBlank((String)password)) {
                ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)username, (String)password);
                repository.setAuthenticationManager(authManager);
            }
            return repository;
        }
        catch (SVNException e) {
            throw new IllegalStateException(e);
        }
    }

    protected SVNURL getSvnUrl(String url) {
        try {
            return SVNURL.parseURIDecoded((String)url);
        }
        catch (SVNException e) {
            throw new IllegalStateException(e);
        }
    }
}

