/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.externals;

import java.io.File;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.kuali.maven.plugins.externals.Mapping;
import org.kuali.maven.plugins.externals.MojoHelper;
import org.kuali.maven.plugins.externals.SVNUtils;

public class ValidatePomsMojo
extends AbstractMojo {
    SVNUtils svnUtils = SVNUtils.getInstance();
    MojoHelper helper = MojoHelper.getInstance();
    private String pom;
    private String ignoreDirectories;
    private MavenProject project;
    private List<Mapping> mappings;

    public void execute() throws MojoExecutionException {
        List<File> files = this.helper.getPoms(this.project.getBasedir(), this.pom, this.ignoreDirectories);
        List<DefaultMutableTreeNode> nodes = this.helper.getNodes(files);
        DefaultMutableTreeNode node = this.helper.getTree(this.project.getBasedir(), nodes, this.pom);
        this.helper.fillInGavs(node);
        Map<String, DefaultMutableTreeNode> map = this.helper.getGavMap(node);
        this.helper.validateParents(node, map);
        this.helper.validateMappings(this.project.getProperties(), this.mappings, node);
        int depth = node.getDepth();
        int size = nodes.size();
        this.getLog().info((CharSequence)("Validated " + size + " POM's.  Multi-module Maven project depth: " + depth));
    }

    public String getPom() {
        return this.pom;
    }

    public void setPom(String pom) {
        this.pom = pom;
    }

    public String getIgnoreDirectories() {
        return this.ignoreDirectories;
    }

    public void setIgnoreDirectories(String ignoreDirectories) {
        this.ignoreDirectories = ignoreDirectories;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public List<Mapping> getMappings() {
        return this.mappings;
    }

    public void setMappings(List<Mapping> mappings) {
        this.mappings = mappings;
    }
}

