/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.jenkins;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.kuali.maven.common.PropertiesUtils;
import org.kuali.maven.plugins.jenkins.Job;
import org.kuali.maven.plugins.jenkins.helper.RsyncHelper;

public class SyncWorkspacesMojo
extends AbstractMojo {
    RsyncHelper helper = new RsyncHelper();
    PropertiesUtils utils = new PropertiesUtils();
    private boolean stats;
    private boolean verbose;
    private boolean forceSync;
    private String trackedBuildNumbers;
    private boolean failOnError;
    private File localJobsDir;
    private String workspaceServerDir;
    private String workspaceServerHostname;
    private String workspaceServerUser;
    private String executable;
    private String ignoreJobs;

    protected List<Job> getJobs(List<File> dirs) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        String prefix = this.localJobsDir.getAbsolutePath();
        for (File dir : dirs) {
            String path = dir.getAbsolutePath();
            int pos = path.lastIndexOf("/workspace");
            String name = path.substring(prefix.length() + 1, pos);
            String src = this.localJobsDir.getAbsolutePath() + "/" + name + "/workspace/";
            String dst = this.workspaceServerUser + "@" + this.workspaceServerHostname + ":" + this.workspaceServerDir + "/" + name;
            int buildNumber = this.getBuildNumber(name);
            Commandline commandLine = this.getCommandLine(src, dst);
            Job job = new Job();
            job.setName(name);
            job.setBuildNumber(buildNumber);
            job.setSrc(src);
            job.setDst(dst);
            job.setCommandLine(commandLine);
            jobs.add(job);
        }
        Collections.sort(jobs);
        return jobs;
    }

    protected int getBuildNumber(String name) {
        File buildNumberFile = new File(this.localJobsDir.getAbsolutePath() + "/" + name + "/nextBuildNumber");
        if (!buildNumberFile.exists()) {
            throw new IllegalStateException("Expected the file " + buildNumberFile + " to be present");
        }
        try {
            String s = FileUtils.readFileToString((File)buildNumberFile);
            return new Integer(s.trim());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected Commandline getCommandLine(String src, String dst) {
        Commandline cl = this.getCommandLine();
        this.addArg(cl, "-a");
        if (this.verbose) {
            this.addArg(cl, "-v");
        }
        if (this.stats) {
            this.addArg(cl, "--stats");
        }
        this.addArg(cl, "--delete");
        this.addArg(cl, src);
        this.addArg(cl, dst);
        return cl;
    }

    protected void execute(List<Job> jobs) throws MojoExecutionException {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(3);
        nf.setMinimumFractionDigits(3);
        Properties p = this.getBuildNumberProperties();
        long elapsed = 0L;
        for (int i = 0; i < jobs.size(); ++i) {
            Job job = jobs.get(i);
            Commandline cl = job.getCommandLine();
            this.getLog().info((CharSequence)(StringUtils.leftPad((String)(i + 1 + ""), (int)3) + " : " + cl.toString()));
            long s1 = System.currentTimeMillis();
            int exitValue = this.executeRsync(cl);
            long s2 = System.currentTimeMillis();
            elapsed += s2 - s1;
            this.getLog().info((CharSequence)("Sync time: " + nf.format((double)(s2 - s1) / 1000.0) + "s"));
            this.validateExitValue(exitValue);
            p.setProperty(job.getName(), job.getBuildNumber() + "");
            this.updateTrackedBuildNumberProperties(p);
        }
        this.getLog().info((CharSequence)("Total Sync time: " + nf.format((double)elapsed / 1000.0) + "s"));
    }

    protected void updateTrackedBuildNumberProperties(Properties p) {
        File file = new File(this.trackedBuildNumbers);
        try {
            this.store(p, file);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void store(Properties p, File file) throws IOException {
        FileOutputStream out = null;
        try {
            out = FileUtils.openOutputStream((File)file);
            p.store(out, "Tracked Build Numbers");
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    protected void createBuildNumberProperties() throws IOException {
        File file = new File(this.trackedBuildNumbers);
        this.store(new Properties(), file);
    }

    protected Properties getBuildNumberProperties() {
        try {
            File file = new File(this.trackedBuildNumbers);
            if (!file.exists()) {
                this.getLog().info((CharSequence)("Creating " + file.getAbsolutePath()));
                this.createBuildNumberProperties();
            }
            return this.utils.getProperties(file.getAbsolutePath());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected List<Job> getTrackedJobs() {
        Properties p = this.getBuildNumberProperties();
        ArrayList<Job> trackedJobs = new ArrayList<Job>();
        for (String name : p.stringPropertyNames()) {
            int buildNumber = new Integer(p.getProperty(name));
            Job job = new Job();
            job.setName(name);
            job.setBuildNumber(buildNumber);
            trackedJobs.add(job);
        }
        Collections.sort(trackedJobs);
        return trackedJobs;
    }

    public void execute() throws MojoExecutionException {
        List<File> wsDirs = this.helper.getWorkspaceDirs(this.localJobsDir);
        this.getLog().info((CharSequence)("Located " + wsDirs.size() + " jobs containing workspaces"));
        List<Job> trackedJobs = this.getTrackedJobs();
        this.getLog().info((CharSequence)("Loaded build number info on " + trackedJobs.size() + " jobs that have been sync'd previously"));
        List<Job> jobs = this.getJobs(wsDirs);
        List<Job> syncJobs = this.getSyncJobs(jobs, trackedJobs);
        int skipped = jobs.size() - syncJobs.size();
        this.getLog().info((CharSequence)("Skipping " + skipped + " jobs"));
        this.getLog().info((CharSequence)("Synchronizing " + syncJobs.size() + " jobs"));
        this.execute(syncJobs);
    }

    protected List<String> getIgnoreList() {
        if (StringUtils.isBlank((String)this.ignoreJobs)) {
            return new ArrayList<String>();
        }
        return Arrays.asList(PropertiesUtils.splitAndTrim((String)this.ignoreJobs, (String)","));
    }

    protected List<Job> getSyncJobs(List<Job> allJobs, List<Job> trackedJobs) {
        List<String> ignoreList = this.getIgnoreList();
        this.getLog().info((CharSequence)("Ignoring " + ignoreList.size() + " jobs"));
        ArrayList<Job> syncJobs = new ArrayList<Job>();
        for (Job job : allJobs) {
            boolean newBuildNumber = this.isNewBuildNumber(job, trackedJobs);
            boolean ignore = ignoreList.contains(job.getName());
            boolean sync = this.forceSync || newBuildNumber && !ignore;
            if (!sync) continue;
            syncJobs.add(job);
        }
        return syncJobs;
    }

    protected boolean isNewBuildNumber(Job job, List<Job> trackedJobs) {
        int currentBuildNumber = job.getBuildNumber();
        for (Job trackedJob : trackedJobs) {
            String name = trackedJob.getName();
            if (!name.equals(job.getName())) continue;
            int previousBuildNumber = trackedJob.getBuildNumber();
            return currentBuildNumber > previousBuildNumber;
        }
        return true;
    }

    protected List<String> getJobNames(List<File> dirs) {
        String prefix = this.localJobsDir.getAbsolutePath();
        ArrayList<String> names = new ArrayList<String>();
        for (File dir : dirs) {
            String path = dir.getAbsolutePath();
            int pos = path.lastIndexOf("/workspace");
            String name = path.substring(prefix.length() + 1, pos);
            names.add(name);
        }
        Collections.sort(names);
        return names;
    }

    protected Commandline getCommandLine() {
        Commandline cl = new Commandline();
        cl.setExecutable(this.executable);
        cl.setWorkingDirectory(this.localJobsDir);
        return cl;
    }

    protected void addArg(Commandline cl, String arg) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(arg);
        this.addArgs(cl, args);
    }

    protected void addArgs(Commandline cl, List<String> args) {
        if (args == null || args.size() == 0) {
            return;
        }
        for (String arg : args) {
            cl.createArg().setValue(arg);
        }
    }

    protected int executeRsync(Commandline cl) throws MojoExecutionException {
        DefaultConsumer stdout = new DefaultConsumer();
        DefaultConsumer stderr = new DefaultConsumer();
        try {
            return CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Error executing " + this.executable, (Exception)((Object)e));
        }
    }

    protected boolean isFail(int exitValue) {
        return this.failOnError && exitValue != 0;
    }

    protected void validateExitValue(int exitValue) throws MojoExecutionException {
        if (this.isFail(exitValue)) {
            throw new MojoExecutionException("Non-zero exit value - " + exitValue);
        }
        if (exitValue != 0) {
            this.getLog().info((CharSequence)("Ignoring non-zero exit value - " + exitValue));
        }
    }

    protected void prepareFileSystem() throws MojoExecutionException {
    }

    public String getWorkspaceServerDir() {
        return this.workspaceServerDir;
    }

    public void setWorkspaceServerDir(String destination) {
        this.workspaceServerDir = destination;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public File getLocalJobsDir() {
        return this.localJobsDir;
    }

    public void setLocalJobsDir(File basedir) {
        this.localJobsDir = basedir;
    }

    public String getWorkspaceServerHostname() {
        return this.workspaceServerHostname;
    }

    public void setWorkspaceServerHostname(String destinationHostname) {
        this.workspaceServerHostname = destinationHostname;
    }

    public String getWorkspaceServerUser() {
        return this.workspaceServerUser;
    }

    public void setWorkspaceServerUser(String destinationUser) {
        this.workspaceServerUser = destinationUser;
    }

    public String getTrackedBuildNumbers() {
        return this.trackedBuildNumbers;
    }

    public void setTrackedBuildNumbers(String buildNumberTracker) {
        this.trackedBuildNumbers = buildNumberTracker;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isStats() {
        return this.stats;
    }

    public void setStats(boolean stats) {
        this.stats = stats;
    }

    public String getIgnoreJobs() {
        return this.ignoreJobs;
    }

    public void setIgnoreJobs(String ignoreJobs) {
        this.ignoreJobs = ignoreJobs;
    }

    public boolean isForceSync() {
        return this.forceSync;
    }

    public void setForceSync(boolean forceSync) {
        this.forceSync = forceSync;
    }
}

