/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.jenkins;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class UpdateParameterizedBuildNumberMojo
extends AbstractMojo {
    private String parameterName;
    private String jobConfigFile;
    private String jobs;
    private File jobsDir;

    public void execute() throws MojoExecutionException {
        try {
            String[] tokens = this.jobs.split(",");
            List<File> configFiles = this.getConfigFiles(this.jobsDir, tokens, this.jobConfigFile);
            this.getLog().info((CharSequence)("Located " + configFiles.size() + " job config files"));
            int buildNumber = this.getBuildNumber();
            this.updateContent(configFiles, buildNumber, this.parameterName);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unexpected error", e);
        }
    }

    protected int getBuildNumber() {
        String s = System.getenv("BUILD_NUMBER");
        if (StringUtils.isBlank((String)s)) {
            throw new IllegalArgumentException("env.BUILD_NUMBER cannot be blank");
        }
        return new Integer(s);
    }

    protected void updateContent(List<File> configFiles, int buildNumber, String parameterName) throws IOException {
        for (File configFile : configFiles) {
            String oldContent = FileUtils.readFileToString((File)configFile);
            String newContent = this.getReplacementContent(oldContent, buildNumber, parameterName);
            this.getLog().info((CharSequence)("Updating " + configFile.getAbsolutePath()));
            File bak = new File(configFile.getAbsolutePath() + ".bak");
            FileUtils.copyFile((File)configFile, (File)bak);
            FileUtils.writeStringToFile((File)configFile, (String)newContent);
        }
    }

    protected String getXmlFragment(String xml, String tag) {
        return StringUtils.substringBetween((String)xml, (String)("<" + tag + ">"), (String)("</" + tag + ">"));
    }

    protected String getReplacementContent(String s, int buildNumber, String parameterName) {
        String parameterDefinition = this.getXmlFragment(s, "hudson.model.StringParameterDefinition");
        String name = this.getXmlFragment(parameterDefinition, "name");
        if (!parameterName.equals(name)) {
            throw new IllegalStateException("Parameter name must equal " + parameterName + " but was '" + name + "' instead");
        }
        String defaultValue = this.getXmlFragment(parameterDefinition, "defaultValue");
        String oldToken = "<defaultValue>" + defaultValue + "</defaultValue>";
        String newToken = "<defaultValue>" + buildNumber + "</defaultValue>";
        int occurs = StringUtils.countMatches((String)s, (String)oldToken);
        if (occurs != 1) {
            throw new IllegalArgumentException(oldToken + " must occur exactly once, but it actually occurs " + occurs);
        }
        return StringUtils.replace((String)s, (String)oldToken, (String)newToken);
    }

    protected List<File> getConfigFiles(File directory, String[] jobs, String configFile) {
        ArrayList<File> files = new ArrayList<File>();
        for (String job : jobs) {
            String filename = directory.getAbsolutePath() + File.separator + job + File.separator + configFile;
            File file = new File(filename);
            if (file.exists()) {
                files.add(file);
                continue;
            }
            this.getLog().warn((CharSequence)(filename + " does not exist"));
        }
        return files;
    }

    public String getJobConfigFile() {
        return this.jobConfigFile;
    }

    public void setJobConfigFile(String jobConfigFile) {
        this.jobConfigFile = jobConfigFile;
    }

    public String getJobs() {
        return this.jobs;
    }

    public void setJobs(String jobs) {
        this.jobs = jobs;
    }

    public File getJobsDir() {
        return this.jobsDir;
    }

    public void setJobsDir(File jobsDir) {
        this.jobsDir = jobsDir;
    }
}

