/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.jenkins.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.kuali.maven.plugins.jenkins.CliMojo;
import org.kuali.maven.plugins.jenkins.Command;
import org.kuali.maven.plugins.jenkins.RunJobCommand;
import org.kuali.maven.plugins.jenkins.SimpleJobCommand;
import org.kuali.maven.plugins.jenkins.helper.Helper;

public class CommandHelper {
    public static final String SPACE = " ";
    public static final String SKIP_IF_NO_CHANGES_ARG = "-c";
    public static final String WAIT_FOR_JOB_TO_FINISH_ARG = "-s";
    public static final String PARAMS_ARG = "-p";

    public List<Command> getCommands(CliMojo mojo) {
        if (!Helper.isEmpty(mojo.getCommands())) {
            return mojo.getCommands();
        }
        Command command = this.getCommand(mojo);
        return Helper.toList(command);
    }

    protected Command getCommand(CliMojo mojo) {
        String[] args = Helper.splitAndTrim(mojo.getCmd(), SPACE);
        Command command = new Command();
        command.setArgs(Arrays.asList(args));
        command.setStdin(mojo.getStdin());
        command.setStdin(mojo.getStdinUrl());
        return command;
    }

    public List<String> toArgs(RunJobCommand command) {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(this.toArgs((SimpleJobCommand)command));
        if (command.isSkipIfNoChanges()) {
            args.add(SKIP_IF_NO_CHANGES_ARG);
        }
        if (command.isWait()) {
            args.add(WAIT_FOR_JOB_TO_FINISH_ARG);
        }
        if (!Helper.isEmpty(command.getParams())) {
            args.add(PARAMS_ARG);
            args.addAll(Helper.toKeyValueList(command.getParams()));
        }
        return args;
    }

    public List<String> toArgs(SimpleJobCommand command) {
        String jenkinsCommand = command.getCommand();
        String jobName = command.getName();
        return Helper.toList(new String[]{jenkinsCommand, jobName});
    }
}

