/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sql;

import org.codehaus.plexus.util.StringUtils;

public class SqlSplitter {
    public static final int NO_END = -1;

    public static int containsSqlEnd(String line, String delimiter) {
        boolean isComment = false;
        boolean isAlphaDelimiter = StringUtils.isAlpha((String)delimiter);
        if (line == null || line.length() == 0) {
            return -1;
        }
        int pos = 0;
        do {
            if (isComment) {
                if (line.startsWith("*/", pos)) {
                    isComment = false;
                } else {
                    ++pos;
                    continue;
                }
            }
            if (line.startsWith("/*", pos)) {
                isComment = true;
                pos += 2;
                continue;
            }
            if (line.startsWith("--", pos)) {
                return -1;
            }
            if (line.startsWith("'", pos) || line.startsWith("\"", pos)) {
                String quoteChar = "" + line.charAt(pos);
                String quoteEscape = "\\" + quoteChar;
                if (line.length() <= ++pos) {
                    return -1;
                }
                do {
                    if (!line.startsWith(quoteEscape, pos)) continue;
                    pos += 2;
                } while (!line.startsWith(quoteChar, pos++));
                continue;
            }
            if (line.startsWith(delimiter, pos)) {
                if (isAlphaDelimiter) {
                    if (!(pos != 0 && SqlSplitter.isAlpha(line.charAt(pos - 1)) || line.length() != pos + delimiter.length() && SqlSplitter.isAlpha(line.charAt(pos + delimiter.length())))) {
                        return pos + delimiter.length();
                    }
                } else {
                    return pos + delimiter.length();
                }
            }
            ++pos;
        } while (line.length() >= pos);
        return -1;
    }

    private static boolean isAlpha(char c) {
        return Character.isUpperCase(c) || Character.isLowerCase(c);
    }
}

