/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.sys.auth;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.sys.extensions.CoreExtensionsKt;
import org.kuali.research.pdf.sys.extensions.ServletExtensionsKt;
import org.springframework.web.util.UriComponentsBuilder;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0002\u001a\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u0001*\u00020\u0012H\u0002\u001a\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0001*\u00020\u0012H\u0002\u001a\f\u0010\u0015\u001a\u00020\u0001*\u00020\u0012H\u0002\u001a\u000e\u0010\u0016\u001a\u0004\u0018\u00010\u0001*\u00020\u0012H\u0002\u001a\u000e\u0010\u0017\u001a\u0004\u0018\u00010\u0001*\u00020\u0012H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u000eX\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u000eX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"ACCESS_TOKEN", "", "AUTH_STATE", "AUTHORIZATION_CODE", "AUTHORIZATION_HEADER_NAME", "AUTHORIZATION_PREFIX", "CLIENT_ID", "GRANT_TYPE", "RESPONSE_TYPE", "REDIRECT_URI", "CODE_PARAM_NAME", "AUTH_TOKEN_NAME", "PDF_COOKIE_NAME", "LOGIN_DURATION_SECONDS", "", "HEX_RADIX", "isOauthReturn", "", "Ljakarta/servlet/http/HttpServletRequest;", "oauthCode", "oauthState", "oauthRedirectUri", "authorization", "authToken", "pdf"})
public final class AuthKt {
    @NotNull
    public static final String ACCESS_TOKEN = "access_token";
    @NotNull
    public static final String AUTH_STATE = "state";
    @NotNull
    public static final String AUTHORIZATION_CODE = "authorization_code";
    @NotNull
    public static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    @NotNull
    public static final String AUTHORIZATION_PREFIX = "Bearer ";
    @NotNull
    public static final String CLIENT_ID = "client_id";
    @NotNull
    public static final String GRANT_TYPE = "grant_type";
    @NotNull
    public static final String RESPONSE_TYPE = "response_type";
    @NotNull
    public static final String REDIRECT_URI = "redirect_uri";
    @NotNull
    public static final String CODE_PARAM_NAME = "code";
    @NotNull
    public static final String AUTH_TOKEN_NAME = "authToken";
    @NotNull
    public static final String PDF_COOKIE_NAME = "pdfAuthToken";
    public static final int LOGIN_DURATION_SECONDS = 600;
    public static final int HEX_RADIX = 16;

    private static final boolean isOauthReturn(HttpServletRequest $this$isOauthReturn) {
        return AuthKt.oauthCode($this$isOauthReturn) != null && AuthKt.oauthState($this$isOauthReturn) != null && ServletExtensionsKt.cookie($this$isOauthReturn, PDF_COOKIE_NAME) != null;
    }

    private static final String oauthCode(HttpServletRequest $this$oauthCode) {
        return $this$oauthCode.getParameter(CODE_PARAM_NAME);
    }

    private static final String oauthState(HttpServletRequest $this$oauthState) {
        return $this$oauthState.getParameter(AUTH_STATE);
    }

    private static final String oauthRedirectUri(HttpServletRequest $this$oauthRedirectUri) {
        StringBuffer stringBuffer = $this$oauthRedirectUri.getRequestURL();
        String string = $this$oauthRedirectUri.getQueryString();
        if (string == null || (string = CoreExtensionsKt.ensurePrefix(string, "?")) == null) {
            string = "";
        }
        String string2 = UriComponentsBuilder.fromUriString((String)(stringBuffer + string)).replaceQueryParam(AUTH_STATE, new Object[0]).replaceQueryParam(CODE_PARAM_NAME, new Object[0]).build().toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUriString(...)");
        return string2;
    }

    private static final String authorization(HttpServletRequest $this$authorization) {
        String string = $this$authorization.getHeader(AUTHORIZATION_HEADER_NAME);
        return string != null ? StringsKt.removePrefix((String)string, (CharSequence)AUTHORIZATION_PREFIX) : null;
    }

    private static final String authToken(HttpServletRequest $this$authToken) {
        String string = AuthKt.authorization($this$authToken);
        if (string == null) {
            Cookie cookie = ServletExtensionsKt.cookie($this$authToken, AUTH_TOKEN_NAME);
            string = cookie != null ? cookie.getValue() : null;
        }
        return string;
    }

    public static final /* synthetic */ String access$authToken(HttpServletRequest $receiver) {
        return AuthKt.authToken($receiver);
    }

    public static final /* synthetic */ boolean access$isOauthReturn(HttpServletRequest $receiver) {
        return AuthKt.isOauthReturn($receiver);
    }

    public static final /* synthetic */ String access$oauthRedirectUri(HttpServletRequest $receiver) {
        return AuthKt.oauthRedirectUri($receiver);
    }

    public static final /* synthetic */ String access$oauthCode(HttpServletRequest $receiver) {
        return AuthKt.oauthCode($receiver);
    }

    public static final /* synthetic */ String access$oauthState(HttpServletRequest $receiver) {
        return AuthKt.oauthState($receiver);
    }
}

