/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.sys.s3;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.sys.health.HealthConstants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;

@Service
@ConditionalOnProperty(name={"aws.s3.enabled"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lorg/kuali/research/pdf/sys/s3/S3HealthIndicator;", "Lorg/springframework/boot/actuate/health/AbstractHealthIndicator;", "Lorg/apache/logging/log4j/kotlin/Logging;", "s3Client", "Lsoftware/amazon/awssdk/services/s3/S3AsyncClient;", "<init>", "(Lsoftware/amazon/awssdk/services/s3/S3AsyncClient;)V", "getS3Client", "()Lsoftware/amazon/awssdk/services/s3/S3AsyncClient;", "doHealthCheck", "", "builder", "Lorg/springframework/boot/actuate/health/Health$Builder;", "pdf"})
public class S3HealthIndicator
extends AbstractHealthIndicator
implements Logging {
    @NotNull
    private final S3AsyncClient s3Client;

    public S3HealthIndicator(@Autowired @NotNull S3AsyncClient s3Client) {
        Intrinsics.checkNotNullParameter((Object)s3Client, (String)"s3Client");
        this.s3Client = s3Client;
    }

    @NotNull
    public S3AsyncClient getS3Client() {
        return this.s3Client;
    }

    /*
     * WARNING - void declaration
     */
    protected void doHealthCheck(@NotNull Health.Builder builder) {
        Status status;
        Health.Builder builder2;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Health.Builder builder3 = builder;
        try {
            builder2 = builder3;
            status = ((ListBucketsResponse)this.getS3Client().listBuckets().get()).sdkHttpResponse().isSuccessful() ? Status.UP : HealthConstants.INSTANCE.getDOWN_NON_FATAL();
        }
        catch (Exception exception) {
            void e;
            builder2 = builder3;
            KotlinLogger kotlinLogger = this.getLogger();
            String string = e.getMessage();
            if (string == null) {
                string = "unknown";
            }
            kotlinLogger.error((CharSequence)string, (Throwable)e);
            builder.withException((Throwable)e);
            status = HealthConstants.INSTANCE.getDOWN_NON_FATAL();
        }
        builder2.status(status);
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }
}

