/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.link.s3;

import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.action.Action;
import org.kuali.research.pdf.link.ActionLink;
import org.kuali.research.pdf.link.ActionLinkInitFinalizeService;
import org.kuali.research.pdf.link.ActionLinkService;
import org.kuali.research.pdf.link.HttpLink;
import org.kuali.research.pdf.link.Link;
import org.kuali.research.pdf.link.s3.S3Service;
import org.owasp.fileio.SafeFile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"aws.s3.enabled"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016J\u001c\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lorg/kuali/research/pdf/link/s3/ActionLinkInitFinalizeServiceS3Impl;", "Lorg/kuali/research/pdf/link/ActionLinkInitFinalizeService;", "actionLinkService", "Lorg/kuali/research/pdf/link/ActionLinkService;", "s3Service", "Lorg/kuali/research/pdf/link/s3/S3Service;", "<init>", "(Lorg/kuali/research/pdf/link/ActionLinkService;Lorg/kuali/research/pdf/link/s3/S3Service;)V", "getActionLinkService", "()Lorg/kuali/research/pdf/link/ActionLinkService;", "getS3Service", "()Lorg/kuali/research/pdf/link/s3/S3Service;", "init", "Lorg/kuali/research/pdf/link/Link;", "link", "Lorg/kuali/research/pdf/link/ActionLink;", "action", "Lorg/kuali/research/pdf/action/Action;", "finalize", "pdf"})
@SourceDebugExtension(value={"SMAP\nActionLinkInitFinalizeServiceS3Impl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActionLinkInitFinalizeServiceS3Impl.kt\norg/kuali/research/pdf/link/s3/ActionLinkInitFinalizeServiceS3Impl\n+ 2 LinkModel.kt\norg/kuali/research/pdf/link/ActionLink\n*L\n1#1,44:1\n183#2,8:45\n*S KotlinDebug\n*F\n+ 1 ActionLinkInitFinalizeServiceS3Impl.kt\norg/kuali/research/pdf/link/s3/ActionLinkInitFinalizeServiceS3Impl\n*L\n37#1:45,8\n*E\n"})
public class ActionLinkInitFinalizeServiceS3Impl
implements ActionLinkInitFinalizeService {
    @NotNull
    private final ActionLinkService actionLinkService;
    @NotNull
    private final S3Service s3Service;

    public ActionLinkInitFinalizeServiceS3Impl(@Autowired @NotNull ActionLinkService actionLinkService, @Autowired @NotNull S3Service s3Service) {
        Intrinsics.checkNotNullParameter((Object)actionLinkService, (String)"actionLinkService");
        Intrinsics.checkNotNullParameter((Object)s3Service, (String)"s3Service");
        this.actionLinkService = actionLinkService;
        this.s3Service = s3Service;
    }

    @NotNull
    public ActionLinkService getActionLinkService() {
        return this.actionLinkService;
    }

    @NotNull
    public S3Service getS3Service() {
        return this.s3Service;
    }

    @Override
    @NotNull
    public Link init(@NotNull ActionLink link, @NotNull Action<?> action) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        String protocol = link.protocol();
        String path = StringsKt.removePrefix((String)link.getUrl(), (CharSequence)(protocol + "://"));
        return link.copy(protocol + "://" + action.getJobId() + "/" + StringsKt.substringAfter$default((String)path, (String)"/", null, (int)2, null));
    }

    @Override
    @NotNull
    public Link finalize(@NotNull ActionLink link, @NotNull Action<?> action) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        SafeFile file = this.getActionLinkService().toFile(link);
        ActionLink this_$iv = link;
        boolean $i$f$getActionId = false;
        String path$iv = StringsKt.removePrefix((String)this_$iv.getUrl(), (CharSequence)(this_$iv.protocol() + "://"));
        String string = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)path$iv, (String)"/", null, (int)2, null), (String)"/", null, (int)2, null);
        this_$iv = link;
        boolean $i$f$getFileNumberPattern = false;
        path$iv = StringsKt.removePrefix((String)this_$iv.getUrl(), (CharSequence)(this_$iv.protocol() + "://"));
        String id = link.getJobId() + "/" + string + "/" + StringsKt.substringAfterLast$default((String)path$iv, (String)"/", null, (int)2, null);
        return (Link)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super HttpLink>, Object>(this, id, file, null){
            int label;
            final /* synthetic */ ActionLinkInitFinalizeServiceS3Impl this$0;
            final /* synthetic */ String $id;
            final /* synthetic */ SafeFile $file;
            {
                this.this$0 = $receiver;
                this.$id = $id;
                this.$file = $file;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = this.this$0.getS3Service().put(this.$id, this.$file, (Continuation<? super Unit>)((Continuation)this));
                        if (v0 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.label = 2;
                        v1 = this.this$0.getS3Service().presignedUrlForRead(this.$id, (Continuation<? super String>)((Continuation)this));
                        if (v1 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl21
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl21:
                        // 2 sources

                        var2_3 = null;
                        var3_4 = 6;
                        var4_5 = null;
                        var5_6 = null;
                        var6_7 = (String)v1;
                        return new HttpLink(var6_7, var5_6, var4_5, var3_4, var2_3);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super HttpLink> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }
}

