/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.split;

import com.itextpdf.forms.PdfPageFormCopier;
import com.itextpdf.kernel.exceptions.BadPasswordException;
import com.itextpdf.kernel.pdf.DocumentProperties;
import com.itextpdf.kernel.pdf.IPdfPageExtraCopier;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfWriter;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.action.Action;
import org.kuali.research.pdf.action.ActionHelperService;
import org.kuali.research.pdf.action.ActionService;
import org.kuali.research.pdf.link.ActionLink;
import org.kuali.research.pdf.link.ActionLinkInitFinalizeService;
import org.kuali.research.pdf.link.Link;
import org.kuali.research.pdf.link.LinkService;
import org.kuali.research.pdf.split.SplitAction;
import org.kuali.research.pdf.sys.extensions.ItextExtensionsKt;
import org.kuali.research.pdf.sys.model.Message;
import org.kuali.research.pdf.sys.model.Props;
import org.kuali.research.pdf.sys.model.Status;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B%\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lorg/kuali/research/pdf/split/SplitActionServiceImpl;", "Lorg/kuali/research/pdf/action/ActionService;", "Lorg/kuali/research/pdf/split/SplitAction;", "Lorg/apache/logging/log4j/kotlin/Logging;", "actionHelperService", "Lorg/kuali/research/pdf/action/ActionHelperService;", "linkService", "Lorg/kuali/research/pdf/link/LinkService;", "actionLinkInitFinalizeService", "Lorg/kuali/research/pdf/link/ActionLinkInitFinalizeService;", "<init>", "(Lorg/kuali/research/pdf/action/ActionHelperService;Lorg/kuali/research/pdf/link/LinkService;Lorg/kuali/research/pdf/link/ActionLinkInitFinalizeService;)V", "getActionHelperService", "()Lorg/kuali/research/pdf/action/ActionHelperService;", "getLinkService", "()Lorg/kuali/research/pdf/link/LinkService;", "getActionLinkInitFinalizeService", "()Lorg/kuali/research/pdf/link/ActionLinkInitFinalizeService;", "init", "action", "exec", "finalize", "pdf"})
@SourceDebugExtension(value={"SMAP\nSplitActionServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SplitActionServiceImpl.kt\norg/kuali/research/pdf/split/SplitActionServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n1563#2:139\n1634#2,3:140\n1563#2:143\n1634#2,3:144\n1563#2:147\n1634#2,3:148\n*S KotlinDebug\n*F\n+ 1 SplitActionServiceImpl.kt\norg/kuali/research/pdf/split/SplitActionServiceImpl\n*L\n48#1:139\n48#1:140,3\n84#1:143\n84#1:144,3\n128#1:147\n128#1:148,3\n*E\n"})
public class SplitActionServiceImpl
implements ActionService<SplitAction>,
Logging {
    @NotNull
    private final ActionHelperService actionHelperService;
    @NotNull
    private final LinkService linkService;
    @NotNull
    private final ActionLinkInitFinalizeService actionLinkInitFinalizeService;

    public SplitActionServiceImpl(@Autowired @NotNull ActionHelperService actionHelperService, @Autowired @NotNull LinkService linkService, @Autowired @NotNull ActionLinkInitFinalizeService actionLinkInitFinalizeService) {
        Intrinsics.checkNotNullParameter((Object)actionHelperService, (String)"actionHelperService");
        Intrinsics.checkNotNullParameter((Object)linkService, (String)"linkService");
        Intrinsics.checkNotNullParameter((Object)actionLinkInitFinalizeService, (String)"actionLinkInitFinalizeService");
        this.actionHelperService = actionHelperService;
        this.linkService = linkService;
        this.actionLinkInitFinalizeService = actionLinkInitFinalizeService;
    }

    @NotNull
    public ActionHelperService getActionHelperService() {
        return this.actionHelperService;
    }

    @NotNull
    public LinkService getLinkService() {
        return this.linkService;
    }

    @NotNull
    public ActionLinkInitFinalizeService getActionLinkInitFinalizeService() {
        return this.actionLinkInitFinalizeService;
    }

    @Override
    @NotNull
    public SplitAction init(@NotNull SplitAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return (SplitAction)this.getActionHelperService().initManual((Action)action, arg_0 -> SplitActionServiceImpl.init$lambda$0(this, arg_0));
    }

    @Override
    @NotNull
    public SplitAction exec(@NotNull SplitAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return (SplitAction)this.getActionHelperService().execManual((Action)action, arg_0 -> SplitActionServiceImpl.exec$lambda$0(this, action, arg_0));
    }

    @Override
    @NotNull
    public SplitAction finalize(@NotNull SplitAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return (SplitAction)this.getActionHelperService().finalizeManual((Action)action, arg_0 -> SplitActionServiceImpl.finalize$lambda$0(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final SplitAction init$lambda$0(SplitActionServiceImpl this$0, SplitAction executingAction) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)executingAction, (String)"executingAction");
        Link source = executingAction.getSource() instanceof ActionLink ? this$0.getActionLinkInitFinalizeService().init((ActionLink)executingAction.getSource(), executingAction) : executingAction.getSource();
        Iterable $this$map$iv = executingAction.getTarget();
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Link link = (Link)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it instanceof ActionLink ? this$0.getActionLinkInitFinalizeService().init((ActionLink)it, executingAction) : it);
        }
        List target = (List)destination$iv$iv;
        return SplitAction.copy$default(executingAction, null, null, source, target, null, null, null, 115, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final SplitAction exec$lambda$0(SplitActionServiceImpl this$0, SplitAction $action, SplitAction executingAction) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)executingAction, (String)"executingAction");
        List executedMessages = CollectionsKt.toMutableList((Collection)executingAction.getMessages());
        try {
            SplitAction splitAction;
            object = (Closeable)new PdfReader(this$0.getLinkService().input(executingAction.getSource()));
            Throwable throwable = null;
            try {
                SplitAction splitAction2;
                PdfReader reader = (PdfReader)object;
                boolean bl = false;
                Closeable closeable = (Closeable)new PdfDocument(reader, (DocumentProperties)this$0.getActionHelperService().getDocumentProperties($action));
                Throwable throwable2 = null;
                try {
                    SplitAction splitAction3;
                    PdfDocument sourceDoc = (PdfDocument)closeable;
                    boolean bl2 = false;
                    if (reader.isEncrypted()) {
                        splitAction3 = executingAction.copyUpdatingProgress(Status.FAIL, Message.Companion.error("The source pdf is encrypted.", "source.encrypted", MapsKt.mapOf(Props.ACTION_NAME.pair(executingAction.getName()))));
                    } else {
                        void $this$mapTo$iv$iv;
                        if (sourceDoc.getNumberOfPages() == 1) {
                            ((Collection)executedMessages).add(Message.Companion.warn("The " + executingAction.getName() + " action only has a source pdf with a single page.", "source.pdf.single.page", MapsKt.mapOf(Props.ACTION_NAME.pair(executingAction.getName()))));
                        }
                        Iterable $this$map$iv = (Iterable)new IntRange(1, sourceDoc.getNumberOfPages());
                        boolean $i$f$map = false;
                        Iterable iterable2 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                        while (iterator2.hasNext()) {
                            void pageNum;
                            int item$iv$iv;
                            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                            Collection collection = destination$iv$iv;
                            boolean bl3 = false;
                            LinkService linkService = this$0.getLinkService();
                            String string = executingAction.getJobId();
                            Intrinsics.checkNotNull((Object)string);
                            String string2 = executingAction.getActionId();
                            Intrinsics.checkNotNull((Object)string2);
                            Link resolvedTarget = linkService.new(string, string2, String.valueOf((int)(pageNum - true)));
                            Closeable closeable2 = (Closeable)new PdfWriter(this$0.getLinkService().output(resolvedTarget));
                            Throwable throwable3 = null;
                            try {
                                PdfWriter writer = (PdfWriter)closeable2;
                                boolean bl4 = false;
                                writer.setSmartMode(true);
                                Closeable closeable3 = (Closeable)new PdfDocument(writer, (DocumentProperties)this$0.getActionHelperService().getDocumentProperties($action));
                                Throwable throwable4 = null;
                                try {
                                    PdfDocument document = (PdfDocument)closeable3;
                                    boolean bl5 = false;
                                    document.initializeOutlines();
                                    sourceDoc.copyPagesTo((int)pageNum, (int)pageNum, document, (IPdfPageExtraCopier)new PdfPageFormCopier());
                                    ItextExtensionsKt.copyAttachmentsTo(sourceDoc, document);
                                    Unit unit = Unit.INSTANCE;
                                }
                                catch (Throwable throwable5) {
                                    throwable4 = throwable5;
                                    throw throwable5;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable4);
                                }
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable6) {
                                throwable3 = throwable6;
                                throw throwable6;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable3);
                            }
                            collection.add(resolvedTarget);
                        }
                        List resolvedTargets = (List)destination$iv$iv;
                        splitAction3 = SplitAction.copy$default(executingAction, null, null, null, resolvedTargets, null, null, executedMessages, 55, null);
                    }
                    splitAction2 = splitAction3;
                }
                catch (Throwable throwable7) {
                    throwable2 = throwable7;
                    throw throwable7;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                }
                splitAction = splitAction2;
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = splitAction;
        }
        catch (BadPasswordException e) {
            this$0.getLogger().debug((Object)e);
            object = executingAction.copyUpdatingProgress(Status.FAIL, Message.Companion.error("The source pdf is encrypted.", "source.encrypted", MapsKt.mapOf(Props.ACTION_NAME.pair(executingAction.getName()))));
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final SplitAction finalize$lambda$0(SplitActionServiceImpl this$0, SplitAction executingAction) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)executingAction, (String)"executingAction");
        Link source = executingAction.getSource() instanceof ActionLink ? this$0.getActionLinkInitFinalizeService().finalize((ActionLink)executingAction.getSource(), executingAction) : executingAction.getSource();
        Iterable $this$map$iv = executingAction.getTarget();
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Link link = (Link)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it instanceof ActionLink ? this$0.getActionLinkInitFinalizeService().finalize((ActionLink)it, executingAction) : it);
        }
        List target = (List)destination$iv$iv;
        return SplitAction.copy$default(executingAction, null, null, source, target, null, null, null, 115, null);
    }
}

