/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.instintegration.internal.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.instintegration.internal.filter.ResInstitutionFilter;
import org.kuali.research.pdf.instintegration.platform.ResPlatformInstitutionFilterService;
import org.kuali.research.pdf.instintegration.sp.ResSpInstitutionFilterService;
import org.kuali.research.pdf.sys.tenancy.TenancyService;
import org.springframework.web.filter.OncePerRequestFilter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/kuali/research/pdf/instintegration/internal/filter/ResInstitutionFilter;", "Lorg/springframework/web/filter/OncePerRequestFilter;", "Lorg/apache/logging/log4j/kotlin/Logging;", "resSpInstitutionFilterService", "Lorg/kuali/research/pdf/instintegration/sp/ResSpInstitutionFilterService;", "resPlatformInstitutionFilterService", "Lorg/kuali/research/pdf/instintegration/platform/ResPlatformInstitutionFilterService;", "tenancyService", "Lorg/kuali/research/pdf/sys/tenancy/TenancyService;", "excludedPathPatterns", "", "", "<init>", "(Lorg/kuali/research/pdf/instintegration/sp/ResSpInstitutionFilterService;Lorg/kuali/research/pdf/instintegration/platform/ResPlatformInstitutionFilterService;Lorg/kuali/research/pdf/sys/tenancy/TenancyService;Ljava/util/Set;)V", "shouldNotFilter", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "doFilterInternal", "", "response", "Ljakarta/servlet/http/HttpServletResponse;", "filterChain", "Ljakarta/servlet/FilterChain;", "pdf"})
@SourceDebugExtension(value={"SMAP\nResInstitutionFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResInstitutionFilter.kt\norg/kuali/research/pdf/instintegration/internal/filter/ResInstitutionFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,34:1\n1761#2,3:35\n*S KotlinDebug\n*F\n+ 1 ResInstitutionFilter.kt\norg/kuali/research/pdf/instintegration/internal/filter/ResInstitutionFilter\n*L\n20#1:35,3\n*E\n"})
public final class ResInstitutionFilter
extends OncePerRequestFilter
implements Logging {
    @NotNull
    private final ResSpInstitutionFilterService resSpInstitutionFilterService;
    @NotNull
    private final ResPlatformInstitutionFilterService resPlatformInstitutionFilterService;
    @NotNull
    private final TenancyService tenancyService;
    @NotNull
    private final Set<String> excludedPathPatterns;

    public ResInstitutionFilter(@NotNull ResSpInstitutionFilterService resSpInstitutionFilterService, @NotNull ResPlatformInstitutionFilterService resPlatformInstitutionFilterService, @NotNull TenancyService tenancyService, @NotNull Set<String> excludedPathPatterns) {
        Intrinsics.checkNotNullParameter((Object)resSpInstitutionFilterService, (String)"resSpInstitutionFilterService");
        Intrinsics.checkNotNullParameter((Object)resPlatformInstitutionFilterService, (String)"resPlatformInstitutionFilterService");
        Intrinsics.checkNotNullParameter((Object)tenancyService, (String)"tenancyService");
        Intrinsics.checkNotNullParameter(excludedPathPatterns, (String)"excludedPathPatterns");
        this.resSpInstitutionFilterService = resSpInstitutionFilterService;
        this.resPlatformInstitutionFilterService = resPlatformInstitutionFilterService;
        this.tenancyService = tenancyService;
        this.excludedPathPatterns = excludedPathPatterns;
    }

    protected boolean shouldNotFilter(@NotNull HttpServletRequest request) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Iterable $this$any$iv = this.excludedPathPatterns;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String string = request.getRequestURI();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRequestURI(...)");
                    CharSequence charSequence = string;
                    if (!new Regex(it).matches(charSequence)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    protected void doFilterInternal(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull FilterChain filterChain) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)filterChain, (String)"filterChain");
        switch (WhenMappings.$EnumSwitchMapping$0[this.tenancyService.getExternalSystemType().ordinal()]) {
            case 1: {
                this.resSpInstitutionFilterService.doFilterInternal(request, response, filterChain);
                break;
            }
            case 2: {
                this.resPlatformInstitutionFilterService.doFilterInternal(request, response, filterChain);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }
}

