/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.sys.internal.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import jakarta.servlet.Filter;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.grants.sys.authintegration.AuthRestClient;
import org.kuali.research.grants.sys.authintegration.internal.client.AuthRestClientImpl;
import org.kuali.research.grants.sys.authintegration.internal.controller.RedirectController;
import org.kuali.research.grants.sys.authintegration.internal.filter.AuthFilter;
import org.kuali.research.grants.sys.authintegration.internal.health.AuthRestClientHealthCheck;
import org.kuali.research.grants.sys.authintegration.internal.service.AuthServiceImpl;
import org.kuali.research.grants.sys.authintegration.internal.service.MutableAuthService;
import org.kuali.research.grants.sys.cache.CacheWarmer;
import org.kuali.research.grants.sys.conversion.SafeConversionService;
import org.kuali.research.grants.sys.conversion.internal.converter.IntToBooleanConverter;
import org.kuali.research.grants.sys.conversion.internal.converter.StringToBooleanConverter;
import org.kuali.research.grants.sys.conversion.internal.formatter.UriFormatter;
import org.kuali.research.grants.sys.conversion.internal.formatter.UrlFormatter;
import org.kuali.research.grants.sys.conversion.internal.service.SafeConversionServiceImpl;
import org.kuali.research.grants.sys.db.internal.tenant.SchemaMultiTenantConnectionProvider;
import org.kuali.research.grants.sys.db.internal.tenant.SchemaMultiTenantFlywayMigrationStrategy;
import org.kuali.research.grants.sys.db.internal.tenant.TenantIdentifierResolver;
import org.kuali.research.grants.sys.logging.LoggingRequestInterceptor;
import org.kuali.research.grants.sys.property.PropertyService;
import org.kuali.research.grants.sys.property.internal.repository.PropertyRepository;
import org.kuali.research.grants.sys.property.internal.service.PropertyServiceImpl;
import org.kuali.research.grants.sys.rest.internal.GlobalRestExceptionHandler;
import org.kuali.research.grants.sys.ssl.TenancyAwareSslBundleLookupService;
import org.kuali.research.grants.sys.ssl.internal.service.TenancyAwareSslBundleLookupServiceImpl;
import org.kuali.research.grants.sys.tenancy.TenancyService;
import org.kuali.research.grants.sys.tenancy.internal.filter.TenancyAwareWebFilter;
import org.kuali.research.grants.sys.tenancy.internal.service.MutableTenancyService;
import org.kuali.research.grants.sys.tenancy.internal.service.TenancyServiceImpl;
import org.kuali.research.grants.sys.xml.SchemaFetcherService;
import org.kuali.research.grants.sys.xml.XmlBeansService;
import org.kuali.research.grants.sys.xml.internal.service.SchemaFetcherAbstractCacheWarmer;
import org.kuali.research.grants.sys.xml.internal.service.SchemaFetcherServiceImpl;
import org.kuali.research.grants.sys.xml.internal.service.SchemaSingleFetcherService;
import org.kuali.research.grants.sys.xml.internal.service.SchemaSingleFetcherServiceImpl;
import org.kuali.research.grants.sys.xml.internal.service.XmlBeansServiceImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationStrategy;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.orm.jpa.HibernatePropertiesCustomizer;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.format.Formatter;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.web.client.RestClient;

@Configuration
@EnableCaching
@EnableAsync
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0017J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\b\u0010\u0014\u001a\u00020\u0015H\u0017J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J\"\u0010\u0012\u001a\u00020\u00182\u000e\b\u0001\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\b\b\u0001\u0010\u001c\u001a\u00020\u001bH\u0017J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0018H\u0017J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0017J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\u0018\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0017J(\u0010+\u001a\u00020,2\u000e\b\u0001\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001b0.2\u000e\b\u0001\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0017J\b\u0010/\u001a\u000200H\u0017J\b\u00101\u001a\u000202H\u0017J\u0018\u00103\u001a\u0002042\u000e\b\u0001\u00105\u001a\b\u0012\u0004\u0012\u0002060\u001aH\u0017J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0017J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0017J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0017J\u0010\u0010?\u001a\u00020@2\u0006\u0010=\u001a\u00020>H\u0017J\u0010\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020DH\u0017J\u0010\u0010E\u001a\u00020F2\u0006\u0010C\u001a\u00020DH\u0017J\b\u0010G\u001a\u00020HH\u0017J\b\u0010I\u001a\u00020JH\u0017\u00a8\u0006K"}, d2={"Lorg/kuali/research/grants/sys/internal/config/SysConfiguration;", "", "<init>", "()V", "schemaSingleFetcherService", "Lorg/kuali/research/grants/sys/xml/internal/service/SchemaSingleFetcherService;", "schemaFetcherCacheWarmer", "Lorg/kuali/research/grants/sys/cache/CacheWarmer;", "cacheProperties", "Lorg/springframework/boot/autoconfigure/cache/CacheProperties;", "SchemaFetcherService", "Lorg/kuali/research/grants/sys/xml/SchemaFetcherService;", "authRestClient", "Lorg/kuali/research/grants/sys/authintegration/AuthRestClient;", "restClientBuilder", "Lorg/springframework/web/client/RestClient$Builder;", "authRestClientHealthCheck", "Lorg/kuali/research/grants/sys/authintegration/internal/health/AuthRestClientHealthCheck;", "tenancyService", "Lorg/kuali/research/grants/sys/tenancy/TenancyService;", "authService", "Lorg/kuali/research/grants/sys/authintegration/internal/service/MutableAuthService;", "authFilter", "Ljakarta/servlet/Filter;", "Lorg/kuali/research/grants/sys/tenancy/internal/service/MutableTenancyService;", "kualiEnvironments", "", "", "kualiEnvironmentSystem", "tenancyAwareWebFilter", "propertyService", "Lorg/kuali/research/grants/sys/property/PropertyService;", "propertyRepository", "Lorg/kuali/research/grants/sys/property/internal/repository/PropertyRepository;", "tenancyAwareSslBundleLookupService", "Lorg/kuali/research/grants/sys/ssl/TenancyAwareSslBundleLookupService;", "tenantIdentifierResolver", "Lorg/springframework/boot/autoconfigure/orm/jpa/HibernatePropertiesCustomizer;", "schemaMultiTenantConnectionProvider", "datasource", "Ljavax/sql/DataSource;", "dataSourceProperties", "Lorg/springframework/boot/autoconfigure/jdbc/DataSourceProperties;", "schemaMultiTenantFlywayMigrationStrategy", "Lorg/springframework/boot/autoconfigure/flyway/FlywayMigrationStrategy;", "commands", "", "xmlBeansService", "Lorg/kuali/research/grants/sys/xml/XmlBeansService;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "loggingRequestInterceptor", "Lorg/springframework/http/client/ClientHttpRequestInterceptor;", "ignoredContentTypes", "Lorg/springframework/http/MediaType;", "safeConversionService", "Lorg/kuali/research/grants/sys/conversion/SafeConversionService;", "conversionService", "Lorg/springframework/core/convert/ConversionService;", "uriFormatter", "Lorg/kuali/research/grants/sys/conversion/internal/formatter/UriFormatter;", "formatterRegistry", "Lorg/springframework/format/FormatterRegistry;", "urlFormatter", "Lorg/kuali/research/grants/sys/conversion/internal/formatter/UrlFormatter;", "intBooleanConverter", "Lorg/kuali/research/grants/sys/conversion/internal/converter/IntToBooleanConverter;", "converterRegistry", "Lorg/springframework/core/convert/converter/ConverterRegistry;", "enhancedStringBooleanConverter", "Lorg/kuali/research/grants/sys/conversion/internal/converter/StringToBooleanConverter;", "globalRestExceptionHandler", "Lorg/kuali/research/grants/sys/rest/internal/GlobalRestExceptionHandler;", "redirectController", "Lorg/kuali/research/grants/sys/authintegration/internal/controller/RedirectController;", "research-grants-backend"})
@SourceDebugExtension(value={"SMAP\nSysConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SysConfiguration.kt\norg/kuali/research/grants/sys/internal/config/SysConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,232:1\n1869#2,2:233\n*S KotlinDebug\n*F\n+ 1 SysConfiguration.kt\norg/kuali/research/grants/sys/internal/config/SysConfiguration\n*L\n178#1:233,2\n*E\n"})
public class SysConfiguration {
    @Bean
    @NotNull
    public SchemaSingleFetcherService schemaSingleFetcherService() {
        return (SchemaSingleFetcherService)new SchemaSingleFetcherServiceImpl();
    }

    @Bean
    @NotNull
    public CacheWarmer schemaFetcherCacheWarmer(@NotNull SchemaSingleFetcherService schemaSingleFetcherService, @NotNull CacheProperties cacheProperties) {
        Intrinsics.checkNotNullParameter((Object)schemaSingleFetcherService, (String)"schemaSingleFetcherService");
        Intrinsics.checkNotNullParameter((Object)cacheProperties, (String)"cacheProperties");
        return (CacheWarmer)new SchemaFetcherAbstractCacheWarmer(cacheProperties, schemaSingleFetcherService);
    }

    @Bean
    @NotNull
    public SchemaFetcherService SchemaFetcherService(@NotNull SchemaSingleFetcherService schemaSingleFetcherService) {
        Intrinsics.checkNotNullParameter((Object)schemaSingleFetcherService, (String)"schemaSingleFetcherService");
        return (SchemaFetcherService)new SchemaFetcherServiceImpl(schemaSingleFetcherService);
    }

    @Bean
    @NotNull
    public AuthRestClient authRestClient(@NotNull RestClient.Builder restClientBuilder) {
        Intrinsics.checkNotNullParameter((Object)restClientBuilder, (String)"restClientBuilder");
        return (AuthRestClient)new AuthRestClientImpl(restClientBuilder);
    }

    @Bean
    @NotNull
    public AuthRestClientHealthCheck authRestClientHealthCheck(@NotNull AuthRestClient authRestClient, @NotNull TenancyService tenancyService) {
        Intrinsics.checkNotNullParameter((Object)authRestClient, (String)"authRestClient");
        Intrinsics.checkNotNullParameter((Object)tenancyService, (String)"tenancyService");
        return new AuthRestClientHealthCheck(authRestClient, tenancyService);
    }

    @Bean
    @NotNull
    public MutableAuthService authService() {
        return (MutableAuthService)new AuthServiceImpl();
    }

    @Bean
    @NotNull
    public Filter authFilter(@NotNull AuthRestClient authRestClient, @NotNull MutableAuthService authService) {
        Intrinsics.checkNotNullParameter((Object)authRestClient, (String)"authRestClient");
        Intrinsics.checkNotNullParameter((Object)authService, (String)"authService");
        Object[] objectArray = new String[]{"/actuator/health", "/favicon.ico"};
        return (Filter)new AuthFilter(SetsKt.setOf((Object[])objectArray), authRestClient, authService);
    }

    @Bean
    @NotNull
    public MutableTenancyService tenancyService(@Value(value="${kuali.environments}") @NotNull Set<String> kualiEnvironments, @Value(value="${kuali.environment.system}") @NotNull String kualiEnvironmentSystem) {
        Intrinsics.checkNotNullParameter(kualiEnvironments, (String)"kualiEnvironments");
        Intrinsics.checkNotNullParameter((Object)kualiEnvironmentSystem, (String)"kualiEnvironmentSystem");
        return (MutableTenancyService)new TenancyServiceImpl(kualiEnvironments, kualiEnvironmentSystem);
    }

    @Bean
    @NotNull
    public Filter tenancyAwareWebFilter(@NotNull MutableTenancyService tenancyService) {
        Intrinsics.checkNotNullParameter((Object)tenancyService, (String)"tenancyService");
        return (Filter)new TenancyAwareWebFilter(tenancyService);
    }

    @Bean
    @NotNull
    public PropertyService propertyService(@NotNull PropertyRepository propertyRepository) {
        Intrinsics.checkNotNullParameter((Object)propertyRepository, (String)"propertyRepository");
        return (PropertyService)new PropertyServiceImpl(propertyRepository);
    }

    @Bean
    @NotNull
    public TenancyAwareSslBundleLookupService tenancyAwareSslBundleLookupService(@NotNull TenancyService tenancyService, @NotNull PropertyService propertyService) {
        Intrinsics.checkNotNullParameter((Object)tenancyService, (String)"tenancyService");
        Intrinsics.checkNotNullParameter((Object)propertyService, (String)"propertyService");
        return (TenancyAwareSslBundleLookupService)new TenancyAwareSslBundleLookupServiceImpl(tenancyService, propertyService);
    }

    @Bean
    @NotNull
    public HibernatePropertiesCustomizer tenantIdentifierResolver(@NotNull TenancyService tenancyService) {
        Intrinsics.checkNotNullParameter((Object)tenancyService, (String)"tenancyService");
        return (HibernatePropertiesCustomizer)new TenantIdentifierResolver(tenancyService);
    }

    @Bean
    @NotNull
    public HibernatePropertiesCustomizer schemaMultiTenantConnectionProvider(@NotNull DataSource datasource, @NotNull DataSourceProperties dataSourceProperties) {
        Intrinsics.checkNotNullParameter((Object)datasource, (String)"datasource");
        Intrinsics.checkNotNullParameter((Object)dataSourceProperties, (String)"dataSourceProperties");
        return (HibernatePropertiesCustomizer)new SchemaMultiTenantConnectionProvider(datasource, dataSourceProperties);
    }

    @Bean
    @NotNull
    public FlywayMigrationStrategy schemaMultiTenantFlywayMigrationStrategy(@Value(value="${grants.flyway.commands}") @NotNull List<String> commands, @Value(value="${kuali.environments}") @NotNull Set<String> kualiEnvironments) {
        Intrinsics.checkNotNullParameter(commands, (String)"commands");
        Intrinsics.checkNotNullParameter(kualiEnvironments, (String)"kualiEnvironments");
        return (FlywayMigrationStrategy)new SchemaMultiTenantFlywayMigrationStrategy(commands, kualiEnvironments);
    }

    @Bean
    @NotNull
    public XmlBeansService xmlBeansService() {
        return (XmlBeansService)new XmlBeansServiceImpl();
    }

    @Bean
    @NotNull
    public ObjectMapper objectMapper() {
        Jackson2ObjectMapperBuilder builder = new Jackson2ObjectMapperBuilder();
        builder.failOnUnknownProperties(true);
        Object[] objectArray = new Object[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS};
        builder.featuresToDisable(objectArray);
        ObjectMapper objectMapper = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"build(...)");
        return objectMapper;
    }

    @Bean
    @NotNull
    public ClientHttpRequestInterceptor loggingRequestInterceptor(@Value(value="${logging.request.interceptor.ignore.content-types}") @NotNull Set<? extends MediaType> ignoredContentTypes) {
        Intrinsics.checkNotNullParameter(ignoredContentTypes, (String)"ignoredContentTypes");
        return (ClientHttpRequestInterceptor)new LoggingRequestInterceptor(ignoredContentTypes);
    }

    @Bean
    @NotNull
    public RestClient.Builder restClientBuilder(@NotNull ObjectMapper objectMapper, @NotNull ClientHttpRequestInterceptor loggingRequestInterceptor) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)loggingRequestInterceptor, (String)"loggingRequestInterceptor");
        RestClient.Builder builder = RestClient.builder().requestInterceptors(arg_0 -> SysConfiguration.restClientBuilder$lambda$0(loggingRequestInterceptor, arg_0)).messageConverters(arg_0 -> SysConfiguration.restClientBuilder$lambda$2(objectMapper, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"messageConverters(...)");
        return builder;
    }

    @Bean
    @NotNull
    public SafeConversionService safeConversionService(@NotNull ConversionService conversionService) {
        Intrinsics.checkNotNullParameter((Object)conversionService, (String)"conversionService");
        return (SafeConversionService)new SafeConversionServiceImpl(conversionService);
    }

    @Bean
    @NotNull
    public UriFormatter uriFormatter(@NotNull FormatterRegistry formatterRegistry) {
        Intrinsics.checkNotNullParameter((Object)formatterRegistry, (String)"formatterRegistry");
        UriFormatter uriFormatter = new UriFormatter();
        formatterRegistry.addFormatter((Formatter)uriFormatter);
        return uriFormatter;
    }

    @Bean
    @NotNull
    public UrlFormatter urlFormatter(@NotNull FormatterRegistry formatterRegistry) {
        Intrinsics.checkNotNullParameter((Object)formatterRegistry, (String)"formatterRegistry");
        UrlFormatter urlFormatter = new UrlFormatter();
        formatterRegistry.addFormatter((Formatter)urlFormatter);
        return urlFormatter;
    }

    @Bean
    @NotNull
    public IntToBooleanConverter intBooleanConverter(@NotNull ConverterRegistry converterRegistry) {
        Intrinsics.checkNotNullParameter((Object)converterRegistry, (String)"converterRegistry");
        IntToBooleanConverter intToBooleanConverter = new IntToBooleanConverter();
        converterRegistry.addConverter((Converter)intToBooleanConverter);
        return intToBooleanConverter;
    }

    @Bean
    @NotNull
    public StringToBooleanConverter enhancedStringBooleanConverter(@NotNull ConverterRegistry converterRegistry) {
        Intrinsics.checkNotNullParameter((Object)converterRegistry, (String)"converterRegistry");
        StringToBooleanConverter stringToBooleanConverter = new StringToBooleanConverter();
        converterRegistry.addConverter((Converter)stringToBooleanConverter);
        return stringToBooleanConverter;
    }

    @Bean
    @NotNull
    public GlobalRestExceptionHandler globalRestExceptionHandler() {
        return new GlobalRestExceptionHandler();
    }

    @Bean
    @NotNull
    public RedirectController redirectController() {
        return new RedirectController();
    }

    private static final void restClientBuilder$lambda$0(ClientHttpRequestInterceptor $loggingRequestInterceptor, List interceptors) {
        interceptors.add($loggingRequestInterceptor);
    }

    private static final void restClientBuilder$lambda$2(ObjectMapper $objectMapper, List converters) {
        Intrinsics.checkNotNull((Object)converters);
        Iterable $this$forEach$iv = converters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HttpMessageConverter converter = (HttpMessageConverter)element$iv;
            boolean bl = false;
            if (!(converter instanceof MappingJackson2HttpMessageConverter)) continue;
            ((MappingJackson2HttpMessageConverter)converter).setObjectMapper($objectMapper);
        }
    }
}

