/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.proposal.internal.service;

import java.net.URL;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import kotlinx.coroutines.CoroutineScopeKt;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kuali.research.grants.opportunity.OpportunityDetails;
import org.kuali.research.grants.opportunity.OpportunityDetailsService;
import org.kuali.research.grants.opportunity.OpportunityPackageDetailsService;
import org.kuali.research.grants.opportunity.internal.model.CfdaModel;
import org.kuali.research.grants.opportunity.internal.model.DataAvailability;
import org.kuali.research.grants.opportunity.internal.model.FormGroupModel;
import org.kuali.research.grants.opportunity.internal.model.FormModel;
import org.kuali.research.grants.opportunity.internal.model.OpportunityPackageDetailsModel;
import org.kuali.research.grants.proposal.internal.dto.PropOppPackageUpsertDto;
import org.kuali.research.grants.proposal.internal.dto.PropOppPkgAssistanceListingUpsertDto;
import org.kuali.research.grants.proposal.internal.dto.PropOppPkgFormUpsertDto;
import org.kuali.research.grants.proposal.internal.dto.PropOpportunityUpsertDto;
import org.kuali.research.grants.proposal.internal.entity.PropOpportunity;
import org.kuali.research.grants.proposal.internal.repository.PropOpportunityRepository;
import org.kuali.research.grants.proposal.internal.service.PropOppPackageService;
import org.kuali.research.grants.proposal.internal.service.PropOpportunityService;
import org.kuali.research.grants.proposal.internal.service.PropOpportunityServiceImpl;
import org.kuali.research.grants.proposal.internal.util.Error;
import org.kuali.research.grants.proposal.internal.util.PropOpportunityId;
import org.kuali.research.grants.sys.Open;
import org.kuali.research.grants.sys.util.Level;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * Exception performing whole class analysis ignored.
 */
@Open
@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J!\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0017\u00a2\u0006\u0004\b\u001c\u0010\u001dJ \u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u001bH\u0097@\u00a2\u0006\u0004\b \u0010!J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0012J\u0018\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u000e2\b\u0010(\u001a\u0004\u0018\u00010)H\u0012J\u0010\u0010*\u001a\u00020+2\u0006\u0010$\u001a\u00020%H\u0012J3\u0010,\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020.0\u000e0-2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b/\u00100R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/kuali/research/grants/proposal/internal/service/PropOpportunityServiceImpl;", "Lorg/kuali/research/grants/proposal/internal/service/PropOpportunityService;", "Lorg/apache/logging/log4j/kotlin/Logging;", "repository", "Lorg/kuali/research/grants/proposal/internal/repository/PropOpportunityRepository;", "opportunityDetailsService", "Lorg/kuali/research/grants/opportunity/OpportunityDetailsService;", "opportunityPackageDetailsService", "Lorg/kuali/research/grants/opportunity/OpportunityPackageDetailsService;", "propOppPackageService", "Lorg/kuali/research/grants/proposal/internal/service/PropOppPackageService;", "<init>", "(Lorg/kuali/research/grants/proposal/internal/repository/PropOpportunityRepository;Lorg/kuali/research/grants/opportunity/OpportunityDetailsService;Lorg/kuali/research/grants/opportunity/OpportunityPackageDetailsService;Lorg/kuali/research/grants/proposal/internal/service/PropOppPackageService;)V", "getAllOpportunitiesForProposal", "", "Lorg/kuali/research/grants/proposal/internal/entity/PropOpportunity;", "proposalId", "Lorg/kuali/research/grants/proposal/internal/util/ProposalId;", "getAllOpportunitiesForProposal-8G5Oh5Q", "(J)Ljava/util/List;", "getPropOpportunityById", "propOpportunityId", "Lorg/kuali/research/grants/proposal/internal/util/PropOpportunityId;", "getPropOpportunityById-ED88gEo", "(JJ)Lorg/kuali/research/grants/proposal/internal/entity/PropOpportunity;", "createPropOpportunity", "propOpportunity", "Lorg/kuali/research/grants/proposal/internal/dto/PropOpportunityUpsertDto;", "createPropOpportunity-Vf9ko8g", "(JLorg/kuali/research/grants/proposal/internal/dto/PropOpportunityUpsertDto;)Lorg/kuali/research/grants/proposal/internal/entity/PropOpportunity;", "createPropOpportunityWithPackages", "propOpportunityUpsertDto", "createPropOpportunityWithPackages-tZlqGmA", "(JLorg/kuali/research/grants/proposal/internal/dto/PropOpportunityUpsertDto;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "buildPropOppPackageUpsertDto", "Lorg/kuali/research/grants/proposal/internal/dto/PropOppPackageUpsertDto;", "packageDetails", "Lorg/kuali/research/grants/opportunity/internal/model/OpportunityPackageDetailsModel;", "getDetailedForms", "Lorg/kuali/research/grants/proposal/internal/dto/PropOppPkgFormUpsertDto;", "formGroup", "Lorg/kuali/research/grants/opportunity/internal/model/FormGroupModel;", "getProvider", "", "deletePropOpportunity", "Lkotlin/Pair;", "Lorg/kuali/research/grants/proposal/internal/util/Error;", "deletePropOpportunity-ED88gEo", "(JJ)Lkotlin/Pair;", "research-grants-backend"})
@SourceDebugExtension(value={"SMAP\nPropOpportunityServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropOpportunityServiceImpl.kt\norg/kuali/research/grants/proposal/internal/service/PropOpportunityServiceImpl\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n*L\n1#1,268:1\n95#2:269\n135#2,3:270\n1869#3,2:273\n1563#3:275\n1634#3,3:276\n1563#3:279\n1634#3,3:280\n1563#3:283\n1634#3,3:284\n30#4:287\n30#4:288\n*S KotlinDebug\n*F\n+ 1 PropOpportunityServiceImpl.kt\norg/kuali/research/grants/proposal/internal/service/PropOpportunityServiceImpl\n*L\n86#1:269\n86#1:270,3\n134#1:273,2\n164#1:275\n164#1:276,3\n209#1:279\n209#1:280,3\n221#1:283\n221#1:284,3\n254#1:287\n263#1:288\n*E\n"})
public class PropOpportunityServiceImpl
implements PropOpportunityService,
Logging {
    @NotNull
    private final PropOpportunityRepository repository;
    @NotNull
    private final OpportunityDetailsService opportunityDetailsService;
    @NotNull
    private final OpportunityPackageDetailsService opportunityPackageDetailsService;
    @NotNull
    private final PropOppPackageService propOppPackageService;

    public PropOpportunityServiceImpl(@NotNull PropOpportunityRepository repository, @NotNull OpportunityDetailsService opportunityDetailsService, @NotNull OpportunityPackageDetailsService opportunityPackageDetailsService, @NotNull PropOppPackageService propOppPackageService) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)opportunityDetailsService, (String)"opportunityDetailsService");
        Intrinsics.checkNotNullParameter((Object)opportunityPackageDetailsService, (String)"opportunityPackageDetailsService");
        Intrinsics.checkNotNullParameter((Object)propOppPackageService, (String)"propOppPackageService");
        this.repository = repository;
        this.opportunityDetailsService = opportunityDetailsService;
        this.opportunityPackageDetailsService = opportunityPackageDetailsService;
        this.propOppPackageService = propOppPackageService;
    }

    @NotNull
    public List<PropOpportunity> getAllOpportunitiesForProposal-8G5Oh5Q(long proposalId) {
        return this.repository.findByProposalId(proposalId);
    }

    @Nullable
    public PropOpportunity getPropOpportunityById-ED88gEo(long proposalId, long propOpportunityId) {
        return (PropOpportunity)OptionalsKt.getOrNull((Optional)this.repository.findByProposalIdAndId(proposalId, propOpportunityId));
    }

    @Transactional
    @NotNull
    public PropOpportunity createPropOpportunity-Vf9ko8g(long proposalId, @NotNull PropOpportunityUpsertDto propOpportunity) {
        Intrinsics.checkNotNullParameter((Object)propOpportunity, (String)"propOpportunity");
        if (propOpportunity.getLinked()) {
            this.repository.findSingleByProposalIdAndLinkedTrue(proposalId).ifPresent(arg_0 -> PropOpportunityServiceImpl.createPropOpportunity_Vf9ko8g$lambda$1(arg_0 -> PropOpportunityServiceImpl.createPropOpportunity_Vf9ko8g$lambda$0(propOpportunity, this, arg_0), arg_0));
        }
        Long l = propOpportunity.getId();
        String string = propOpportunity.getOpportunityNumber();
        String string2 = propOpportunity.getOpportunityTitle();
        long l2 = proposalId;
        boolean bl = propOpportunity.getLinked();
        long l3 = propOpportunity.getGgOpportunityId();
        PropOpportunity propOpportunity2 = new PropOpportunity(l, string, string2, bl, Long.valueOf(l2), null, null, null, l3, 224, null);
        Object object = this.repository.save((Object)propOpportunity2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"save(...)");
        return (PropOpportunity)object;
    }

    @Transactional
    @Nullable
    public Object createPropOpportunityWithPackages-tZlqGmA(long proposalId, @NotNull PropOpportunityUpsertDto propOpportunityUpsertDto, @NotNull Continuation<? super PropOpportunity> $completion) {
        return PropOpportunityServiceImpl.createPropOpportunityWithPackages-tZlqGmA$suspendImpl((PropOpportunityServiceImpl)this, (long)proposalId, (PropOpportunityUpsertDto)propOpportunityUpsertDto, $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Transactional
    static /* synthetic */ Object createPropOpportunityWithPackages-tZlqGmA$suspendImpl(PropOpportunityServiceImpl $this, long proposalId, PropOpportunityUpsertDto propOpportunityUpsertDto, Continuation<? super PropOpportunity> $completion) {
        if (!($completion instanceof createPropOpportunityWithPackages.1)) ** GOTO lbl-1000
        var16_4 = $completion;
        if ((var16_4.label & -2147483648) != 0) {
            var16_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new /* Unavailable Anonymous Inner Class!! */;
        }
        $result = $continuation.result;
        var17_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                createdPropOpportunity = $this.createPropOpportunity-Vf9ko8g(proposalId, propOpportunityUpsertDto);
                $i$f$measureTimedValue = false;
                $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
                $i$f$measureTimedValue = false;
                mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
                $i$a$-measureTimedValue-PropOpportunityServiceImpl$createPropOpportunityWithPackages$opportunityDetails$1 = false;
                result$iv$iv = $this.opportunityDetailsService.getOpportunityDetails((int)propOpportunityUpsertDto.getGgOpportunityId());
                result = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
                $i$a$-let-PropOpportunityServiceImpl$createPropOpportunityWithPackages$opportunityDetails$2 = false;
                $this.getLogger().info((CharSequence)("Fetched opportunity details from grants.gov for ID: " + propOpportunityUpsertDto.getGgOpportunityId() + " in " + Duration.toString-impl((long)result.getDuration-UwyO8pc())));
                opportunityDetails = (OpportunityDetails)result.getValue();
                if (opportunityDetails == null) {
                    $this.getLogger().error((CharSequence)("Opportunity details not found for ID: " + propOpportunityUpsertDto.getGgOpportunityId()));
                    throw new IllegalArgumentException("Opportunity details not found for ID: " + propOpportunityUpsertDto.getGgOpportunityId());
                }
                $continuation.L$0 = $this;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)propOpportunityUpsertDto);
                $continuation.L$2 = createdPropOpportunity;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)opportunityDetails);
                $continuation.J$0 = proposalId;
                $continuation.label = 1;
                v0 = CoroutineScopeKt.coroutineScope((Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (Continuation)$continuation);
                if (v0 == var17_6) {
                    return var17_6;
                }
                ** GOTO lbl47
            }
            case 1: {
                proposalId = $continuation.J$0;
                opportunityDetails = (OpportunityDetails)$continuation.L$3;
                createdPropOpportunity = (PropOpportunity)$continuation.L$2;
                propOpportunityUpsertDto = (PropOpportunityUpsertDto)$continuation.L$1;
                $this = (PropOpportunityServiceImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl47:
                // 2 sources

                packageDetailsList = (List)v0;
                $this$forEach$iv = packageDetailsList;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    pkg = (OpportunityPackageDetailsModel)element$iv;
                    $i$a$-forEach-PropOpportunityServiceImpl$createPropOpportunityWithPackages$2 = false;
                    propOppPackageUpsertDto = $this.buildPropOppPackageUpsertDto(pkg);
                    v1 = $this.propOppPackageService;
                    v2 = createdPropOpportunity.getId();
                    Intrinsics.checkNotNull((Object)v2);
                    v1.createOrUpdatePropOppPackage-Zfh2DEQ(proposalId, PropOpportunityId.constructor-impl((long)v2), propOppPackageUpsertDto);
                }
                v3 = $this.repository;
                v4 = createdPropOpportunity.getId();
                Intrinsics.checkNotNull((Object)v4);
                retPropOpportunity = (PropOpportunity)OptionalsKt.getOrNull((Optional)v3.findByProposalIdAndId(proposalId, v4.longValue()));
                if (retPropOpportunity == null) {
                    $this.getLogger().error((CharSequence)("Created PropOpportunity with ID: " + createdPropOpportunity.getId() + " not found in the database."));
                    throw new IllegalStateException("Created PropOpportunity not found in the database.");
                }
                return retPropOpportunity;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private PropOppPackageUpsertDto buildPropOppPackageUpsertDto(OpportunityPackageDetailsModel packageDetails) {
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = packageDetails.getCfdas();
        boolean $i$f$map = false;
        Object object2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void cfda;
            object = (CfdaModel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = cfda.getCfdaNumber();
            Intrinsics.checkNotNull((Object)string);
            collection.add(new PropOppPkgAssistanceListingUpsertDto(null, string, cfda.getProgramTitle(), null));
        }
        List als = (List)destination$iv$iv;
        if (packageDetails.getSchemaURL() == null) {
            this.getLogger().error((CharSequence)("Schema URL cannot be null for package ID: " + packageDetails.getPackageId()));
            throw new IllegalArgumentException("Schema URL cannot be null for package ID: " + packageDetails.getPackageId());
        }
        List forms = this.getDetailedForms((FormGroupModel)CollectionsKt.getOrNull((List)packageDetails.getFormGroups(), (int)0));
        boolean isNih = packageDetails.getDataAvailability().get("SADS") == DataAvailability.AVAILABLE;
        object2 = packageDetails.getPackageId();
        String string = packageDetails.getCompetitionId();
        String string2 = packageDetails.getCompetitionTitle();
        ZonedDateTime zonedDateTime = packageDetails.getOpeningDate();
        LocalDate localDate = zonedDateTime != null ? zonedDateTime.toLocalDate() : null;
        ZonedDateTime zonedDateTime2 = packageDetails.getClosingDate();
        LocalDate localDate2 = zonedDateTime2 != null ? zonedDateTime2.toLocalDate() : null;
        object = this.getProvider(packageDetails);
        URL uRL = packageDetails.getSchemaURL();
        URL uRL2 = packageDetails.getInstructionsUrl();
        return new PropOppPackageUpsertDto(null, (String)object2, string, string2, isNih, localDate, localDate2, (String)object, uRL, uRL2, true, als, forms, null);
    }

    /*
     * WARNING - void declaration
     */
    private List<PropOppPkgFormUpsertDto> getDetailedForms(FormGroupModel formGroup) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        if (formGroup == null) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = formGroup.getMandatoryForms();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            FormModel formModel = (FormModel)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new PropOppPkgFormUpsertDto(null, it.getFormName(), it.getVersion(), true, true, null));
        }
        List mandatoryForms = (List)destination$iv$iv;
        Iterable $this$map$iv2 = formGroup.getOptionalForms();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FormModel bl = (FormModel)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(new PropOppPkgFormUpsertDto(null, it.getFormName(), it.getVersion(), false, true, null));
        }
        List optionalForms = (List)destination$iv$iv2;
        return CollectionsKt.plus((Collection)mandatoryForms, (Iterable)optionalForms);
    }

    private String getProvider(OpportunityPackageDetailsModel packageDetails) {
        String string;
        URL schemaUrl = packageDetails.getSchemaURL();
        if (schemaUrl == null) {
            string = "grants.gov";
        } else {
            String string2 = schemaUrl.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            string = StringsKt.contains$default((CharSequence)string2, (CharSequence)"training.grants.gov", (boolean)false, (int)2, null) ? "training.grants.gov" : "grants.gov";
        }
        return string;
    }

    @NotNull
    public Pair<PropOpportunity, List<Error>> deletePropOpportunity-ED88gEo(long proposalId, long propOpportunityId) {
        Pair pair;
        PropOpportunity propOpportunity = (PropOpportunity)OptionalsKt.getOrNull((Optional)this.repository.findByProposalIdAndId(proposalId, propOpportunityId));
        if (propOpportunity == null) {
            String message = "No PropOpportunity found for proposal ID: " + proposalId + " and opportunity ID: " + propOpportunityId + ".";
            PropOpportunityServiceImpl $this$logger$iv = this;
            boolean $i$f$logger = false;
            LoggingFactoryKt.loggerOf(PropOpportunityServiceImpl.class).error((CharSequence)message);
            return TuplesKt.to(null, (Object)CollectionsKt.listOf((Object)new Error(message, Level.SEVERE)));
        }
        try {
            this.repository.delete((Object)propOpportunity);
            pair = TuplesKt.to((Object)propOpportunity, (Object)CollectionsKt.emptyList());
        }
        catch (Exception e) {
            String message = "Failed to delete PropOpportunity with ID: " + propOpportunity.getId() + ".";
            PropOpportunityServiceImpl $this$logger$iv = this;
            boolean $i$f$logger = false;
            LoggingFactoryKt.loggerOf(PropOpportunityServiceImpl.class).error((CharSequence)(message + " " + e.getMessage()), (Throwable)e);
            pair = TuplesKt.to(null, (Object)CollectionsKt.listOf((Object)new Error(message, Level.SEVERE)));
        }
        return pair;
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }

    private static final Unit createPropOpportunity_Vf9ko8g$lambda$0(PropOpportunityUpsertDto $propOpportunity, PropOpportunityServiceImpl this$0, PropOpportunity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!Intrinsics.areEqual((Object)$propOpportunity.getId(), (Object)it.getId())) {
            this$0.repository.save((Object)PropOpportunity.copy$default((PropOpportunity)it, null, null, null, (boolean)false, null, null, null, null, (long)0L, (int)503, null));
        }
        return Unit.INSTANCE;
    }

    private static final void createPropOpportunity_Vf9ko8g$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ OpportunityPackageDetailsService access$getOpportunityPackageDetailsService$p(PropOpportunityServiceImpl $this) {
        return $this.opportunityPackageDetailsService;
    }
}

