CREATE TABLE FILE (
  id BIGSERIAL PRIMARY KEY,
  name VARCHAR(255) NOT NULL,
  content_type VARCHAR(100) NOT NULL,
  size BIGINT NOT NULL,
  data BYTEA NOT NULL,
  inserted_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE PROP_OPP_PKG_FORM_OVERRIDE (
  ID BIGSERIAL PRIMARY KEY,
  name VARCHAR(255) NOT NULL,
  form_version VARCHAR(10) NOT NULL,
  active BOOLEAN NOT NULL,
  prop_opp_package_id BIGINT NOT NULL,
  pdf_file_id BIGINT NOT NULL UNIQUE,
  xml_file_id BIGINT NOT NULL UNIQUE,
  inserted_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  CONSTRAINT FK_FORM_OVERRIDE_PKG FOREIGN KEY (prop_opp_package_id) REFERENCES PROP_OPP_PACKAGE (id) ON DELETE CASCADE,
  CONSTRAINT FK_FORM_OVERRIDE_PDF FOREIGN KEY (pdf_file_id) REFERENCES FILE (id),
  CONSTRAINT FK_FORM_OVERRIDE_XML FOREIGN KEY (xml_file_id) REFERENCES FILE (id)
);

CREATE TABLE PROP_OPP_PKG_FORM_OVRD_ATTACHMENT (
  id BIGSERIAL PRIMARY KEY,
  file_key VARCHAR(255) NOT NULL,
  file_name VARCHAR(255) NOT NULL,
  attachment_file_id BIGINT NOT NULL UNIQUE,
  prop_opp_pkg_form_override_id BIGINT NOT NULL,
  inserted_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  CONSTRAINT FK_OVRD_ATTACHMENT_OVERRIDE FOREIGN KEY (prop_opp_pkg_form_override_id) REFERENCES PROP_OPP_PKG_FORM_OVERRIDE (id) ON DELETE CASCADE,
  CONSTRAINT FK_OVRD_ATTACHMENT_FILE FOREIGN KEY (attachment_file_id) REFERENCES FILE (id)
);

-- cascade deletes
ALTER TABLE PROP_OPPORTUNITY
DROP CONSTRAINT fk_proposal;

ALTER TABLE PROP_OPPORTUNITY
ADD CONSTRAINT FK_OPPORTUNITY_PROPOSAL FOREIGN KEY (proposal_id) REFERENCES PROPOSAL (id) ON DELETE CASCADE;

ALTER TABLE PROP_OPP_PACKAGE
DROP CONSTRAINT fk_opportunity;

ALTER TABLE PROP_OPP_PACKAGE
ADD CONSTRAINT FK_PACKAGE_OPPORTUNITY FOREIGN KEY (prop_opportunity_id) REFERENCES PROP_OPPORTUNITY (id) ON DELETE CASCADE;

ALTER TABLE PROP_OPP_PKG_ASSISTANCE_LISTING
DROP CONSTRAINT fk_opportunity_package;

ALTER TABLE PROP_OPP_PKG_ASSISTANCE_LISTING
ADD CONSTRAINT FK_ASSISTANCE_LISTING_PACKAGE FOREIGN KEY (prop_opp_package_id) REFERENCES PROP_OPP_PACKAGE (id) ON DELETE CASCADE;

ALTER TABLE PROP_OPP_PKG_FORM
DROP CONSTRAINT fk_opportunity_package_form;

ALTER TABLE PROP_OPP_PKG_FORM
ADD CONSTRAINT FK_FORM_PACKAGE FOREIGN KEY (prop_opp_package_id) REFERENCES PROP_OPP_PACKAGE (id) ON DELETE CASCADE;

ALTER TABLE PROP_OPP_PKG_SUBMISSION_OPTIONS
DROP CONSTRAINT fk_opportunity_package_submission;

ALTER TABLE PROP_OPP_PKG_SUBMISSION_OPTIONS
ADD CONSTRAINT FK_SUBMISSION_OPTIONS_PACKAGE FOREIGN KEY (prop_opp_package_id) REFERENCES PROP_OPP_PACKAGE (id) ON DELETE CASCADE;
