/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.sys.xml.internal.service;

import java.net.MalformedURLException;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.grants.sys.xml.SchemaFetcherService;
import org.kuali.research.grants.sys.xml.internal.service.SchemaFetcherServiceImpl;
import org.kuali.research.grants.sys.xml.internal.service.SchemaSingleFetcherService;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0005\b\u0017\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\tH\u0016J$\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\t2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u000fH\u0012J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/kuali/research/grants/sys/xml/internal/service/SchemaFetcherServiceImpl;", "Lorg/kuali/research/grants/sys/xml/SchemaFetcherService;", "Lorg/apache/logging/log4j/kotlin/Logging;", "schemaSingleFetcherService", "Lorg/kuali/research/grants/sys/xml/internal/service/SchemaSingleFetcherService;", "<init>", "(Lorg/kuali/research/grants/sys/xml/internal/service/SchemaSingleFetcherService;)V", "fetchSchemas", "", "", "Lorg/springframework/core/io/Resource;", "schemaLocation", "fetchSchemasRecursiveInternal", "", "schemas", "", "resolveUrl", "base", "relative", "Companion", "research-grants-backend"})
@SourceDebugExtension(value={"SMAP\nSchemaFetcherServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaFetcherServiceImpl.kt\norg/kuali/research/grants/sys/xml/internal/service/SchemaFetcherServiceImpl\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n95#2:82\n135#2,3:83\n1#3:86\n*S KotlinDebug\n*F\n+ 1 SchemaFetcherServiceImpl.kt\norg/kuali/research/grants/sys/xml/internal/service/SchemaFetcherServiceImpl\n*L\n27#1:82\n27#1:83,3\n*E\n"})
public class SchemaFetcherServiceImpl
implements SchemaFetcherService,
Logging {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SchemaSingleFetcherService schemaSingleFetcherService;
    @NotNull
    private static final Set<String> NODES_WITH_SCHEMA_LOCATION;
    @NotNull
    private static final String SCHEMA_LOCATION_ATTR_NAME = "schemaLocation";
    @NotNull
    private static final String XML_SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";

    public SchemaFetcherServiceImpl(@NotNull SchemaSingleFetcherService schemaSingleFetcherService) {
        Intrinsics.checkNotNullParameter((Object)schemaSingleFetcherService, (String)"schemaSingleFetcherService");
        this.schemaSingleFetcherService = schemaSingleFetcherService;
    }

    @NotNull
    public Map<String, Resource> fetchSchemas(@NotNull String schemaLocation) {
        Intrinsics.checkNotNullParameter((Object)schemaLocation, (String)SCHEMA_LOCATION_ATTR_NAME);
        Map schemas = new LinkedHashMap();
        this.fetchSchemasRecursiveInternal(schemaLocation, schemas);
        return schemas;
    }

    private void fetchSchemasRecursiveInternal(String schemaLocation, Map<String, Resource> schemas) {
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        Pair result$iv$iv = this.schemaSingleFetcherService.fetchSchema(schemaLocation);
        TimedValue result = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        boolean bl2 = false;
        this.getLogger().info((CharSequence)("Fetched single schema from grants.gov in " + Duration.toString-impl((long)result.getDuration-UwyO8pc()) + " at " + schemaLocation));
        Pair result2 = (Pair)result.getValue();
        if (result2 == null) {
            return;
        }
        String namespace = (String)result2.component1();
        Resource resource = (Resource)result2.component2();
        if (schemas.containsKey(namespace)) {
            return;
        }
        schemas.put(namespace, resource);
        DocumentBuilderFactory $this$fetchSchemasRecursiveInternal_u24lambda_u242 = mark$iv$iv = DocumentBuilderFactory.newInstance();
        boolean bl3 = false;
        $this$fetchSchemasRecursiveInternal_u24lambda_u242.setNamespaceAware(true);
        Document doc = mark$iv$iv.newDocumentBuilder().parse(resource.getInputStream());
        Element root = doc.getDocumentElement();
        for (String nodeName : NODES_WITH_SCHEMA_LOCATION) {
            NodeList nodeList = root.getElementsByTagNameNS(XML_SCHEMA_NS, nodeName);
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Object object;
                Element el;
                Object object2 = nodeList.item(i);
                if ((object2 instanceof Element ? (Element)object2 : null) == null) continue;
                el = el;
                Object it = object2 = el.getAttribute(SCHEMA_LOCATION_ATTR_NAME);
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)it);
                Object object3 = object = ((CharSequence)it).length() > 0 ? object2 : null;
                if (object == null) continue;
                Object schemaLocationAttr = object;
                boolean bl5 = false;
                object2 = this.resolveUrl(schemaLocation, (String)schemaLocationAttr);
                if (object2 == null) continue;
                Object nextUrl = object2;
                boolean bl6 = false;
                this.fetchSchemasRecursiveInternal((String)nextUrl, schemas);
            }
        }
    }

    private String resolveUrl(String base, String relative) {
        String string;
        try {
            string = new URI(base).resolve(relative).toURL().toString();
            Intrinsics.checkNotNull((Object)string);
        }
        catch (MalformedURLException e) {
            this.getLogger().debug((CharSequence)("failed to resolve url with base " + base + ", relative " + relative + ", returning " + relative), (Throwable)e);
            string = relative;
        }
        return string;
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }

    static {
        Object[] objectArray = new String[]{"import", "include", "redefine"};
        NODES_WITH_SCHEMA_LOCATION = SetsKt.setOf((Object[])objectArray);
    }
}

