/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.proposal.internal.controller;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kuali.research.grants.proposal.internal.entity.SubmissionType;
import org.kuali.research.grants.proposal.internal.model.SubmissionTypeModel;
import org.kuali.research.grants.proposal.internal.service.SubmissionTypeService;
import org.kuali.research.grants.proposal.internal.util.SubmissionTypeId;
import org.kuali.research.grants.sys.hateoas.ProblemModel;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/submission-types"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0017\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ+\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\r0\f0\u000b2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0017\u00a2\u0006\u0002\u0010\u0010J\u001e\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\f0\u000b2\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/kuali/research/grants/proposal/internal/controller/SubmissionTypeController;", "", "service", "Lorg/kuali/research/grants/proposal/internal/service/SubmissionTypeService;", "assembler", "Lorg/springframework/hateoas/server/RepresentationModelAssembler;", "Lorg/kuali/research/grants/proposal/internal/entity/SubmissionType;", "Lorg/kuali/research/grants/proposal/internal/model/SubmissionTypeModel;", "<init>", "(Lorg/kuali/research/grants/proposal/internal/service/SubmissionTypeService;Lorg/springframework/hateoas/server/RepresentationModelAssembler;)V", "all", "Lorg/springframework/http/ResponseEntity;", "Lorg/kuali/research/grants/sys/hateoas/ProblemModel;", "Lorg/springframework/hateoas/CollectionModel;", "active", "", "(Ljava/lang/Boolean;)Lorg/springframework/http/ResponseEntity;", "one", "id", "", "research-grants-backend"})
public class SubmissionTypeController {
    @NotNull
    private final SubmissionTypeService service;
    @NotNull
    private final RepresentationModelAssembler<SubmissionType, SubmissionTypeModel> assembler;

    public SubmissionTypeController(@NotNull SubmissionTypeService service, @NotNull RepresentationModelAssembler<SubmissionType, SubmissionTypeModel> assembler) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter(assembler, (String)"assembler");
        this.service = service;
        this.assembler = assembler;
    }

    @GetMapping
    @NotNull
    public ResponseEntity<ProblemModel<CollectionModel<SubmissionTypeModel>>> all(@RequestParam(required=false) @Nullable Boolean active) {
        List submissionTypes = active != null ? this.service.getAllByActiveStatus(active.booleanValue()) : this.service.getAll();
        RepresentationModel representationModel = this.assembler.toCollectionModel((Iterable)submissionTypes).add(WebMvcLinkBuilder.linkTo((Object)((SubmissionTypeController)WebMvcLinkBuilder.methodOn(SubmissionTypeController.class, (Object[])new Object[0])).all(active)).withSelfRel());
        Intrinsics.checkNotNullExpressionValue((Object)representationModel, (String)"add(...)");
        ResponseEntity responseEntity = ResponseEntity.ok((Object)ProblemModel.Companion.victory$default((ProblemModel.Companion)ProblemModel.Companion, (RepresentationModel)representationModel, null, (int)2, null));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @GetMapping(value={"/{id}"})
    @NotNull
    public ResponseEntity<ProblemModel<SubmissionTypeModel>> one(@PathVariable long id) {
        SubmissionType submissionType;
        block3: {
            block2: {
                SubmissionType submissionType2 = this.service.getSubmissionTypeById-dEFTQ4w(SubmissionTypeId.constructor-impl((long)id));
                submissionType = submissionType2;
                if (submissionType == null) break block2;
                SubmissionType it = submissionType;
                boolean bl = false;
                RepresentationModel representationModel = this.assembler.toModel((Object)submissionType2);
                Intrinsics.checkNotNullExpressionValue((Object)representationModel, (String)"toModel(...)");
                ResponseEntity responseEntity = ResponseEntity.ok((Object)ProblemModel.Companion.victory$default((ProblemModel.Companion)ProblemModel.Companion, (RepresentationModel)representationModel, null, (int)2, null));
                submissionType = responseEntity;
                if (responseEntity != null) break block3;
            }
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.NOT_FOUND)).body((Object)ProblemModel.Companion.empty());
            submissionType = responseEntity;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        }
        return submissionType;
    }
}

