/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.sys.conversion.internal.formatter;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.format.Formatter;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lorg/kuali/research/grants/sys/conversion/internal/formatter/UriFormatter;", "Lorg/springframework/format/Formatter;", "Ljava/net/URI;", "<init>", "()V", "print", "", "uri", "locale", "Ljava/util/Locale;", "parse", "text", "research-grants-backend"})
public class UriFormatter
implements Formatter<URI> {
    @NotNull
    public String print(@NotNull URI uri, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        String string = uri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public URI parse(@NotNull String text, @NotNull Locale locale) {
        URI uRI;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        try {
            uRI = new URI(text);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to parse URI " + text, e);
        }
        return uRI;
    }
}

