/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.resintegration.internal.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.grants.resintegration.internal.filter.ResAuthFilter;
import org.kuali.research.grants.resintegration.platform.auth.ResPlatformAuthFilterService;
import org.kuali.research.grants.resintegration.sp.auth.ResSpAuthFilterService;
import org.kuali.research.grants.sys.tenancy.TenancyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
@Order(value=2)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B5\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/kuali/research/grants/resintegration/internal/filter/ResAuthFilter;", "Lorg/springframework/web/filter/OncePerRequestFilter;", "resSpAuthFilterService", "Lorg/kuali/research/grants/resintegration/sp/auth/ResSpAuthFilterService;", "resPlatformAuthFilterService", "Lorg/kuali/research/grants/resintegration/platform/auth/ResPlatformAuthFilterService;", "tenancyService", "Lorg/kuali/research/grants/sys/tenancy/TenancyService;", "excludedUrls", "", "", "<init>", "(Lorg/kuali/research/grants/resintegration/sp/auth/ResSpAuthFilterService;Lorg/kuali/research/grants/resintegration/platform/auth/ResPlatformAuthFilterService;Lorg/kuali/research/grants/sys/tenancy/TenancyService;Ljava/util/Set;)V", "shouldNotFilter", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "doFilterInternal", "", "response", "Ljakarta/servlet/http/HttpServletResponse;", "filterChain", "Ljakarta/servlet/FilterChain;", "research-grants-backend"})
@SourceDebugExtension(value={"SMAP\nResAuthFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResAuthFilter.kt\norg/kuali/research/grants/resintegration/internal/filter/ResAuthFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n1761#2,3:43\n*S KotlinDebug\n*F\n+ 1 ResAuthFilter.kt\norg/kuali/research/grants/resintegration/internal/filter/ResAuthFilter\n*L\n24#1:43,3\n*E\n"})
public class ResAuthFilter
extends OncePerRequestFilter {
    @NotNull
    private final ResSpAuthFilterService resSpAuthFilterService;
    @NotNull
    private final ResPlatformAuthFilterService resPlatformAuthFilterService;
    @NotNull
    private final TenancyService tenancyService;
    @NotNull
    private final Set<String> excludedUrls;

    public ResAuthFilter(@Autowired @NotNull ResSpAuthFilterService resSpAuthFilterService, @Autowired @NotNull ResPlatformAuthFilterService resPlatformAuthFilterService, @Autowired @NotNull TenancyService tenancyService, @NotNull Set<String> excludedUrls) {
        Intrinsics.checkNotNullParameter((Object)resSpAuthFilterService, (String)"resSpAuthFilterService");
        Intrinsics.checkNotNullParameter((Object)resPlatformAuthFilterService, (String)"resPlatformAuthFilterService");
        Intrinsics.checkNotNullParameter((Object)tenancyService, (String)"tenancyService");
        Intrinsics.checkNotNullParameter(excludedUrls, (String)"excludedUrls");
        this.resSpAuthFilterService = resSpAuthFilterService;
        this.resPlatformAuthFilterService = resPlatformAuthFilterService;
        this.tenancyService = tenancyService;
        this.excludedUrls = excludedUrls;
    }

    public /* synthetic */ ResAuthFilter(ResSpAuthFilterService resSpAuthFilterService, ResPlatformAuthFilterService resPlatformAuthFilterService, TenancyService tenancyService, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            Object[] objectArray = new String[]{"/actuator/health", "/favicon.ico"};
            set = SetsKt.setOf((Object[])objectArray);
        }
        this(resSpAuthFilterService, resPlatformAuthFilterService, tenancyService, set);
    }

    protected boolean shouldNotFilter(@NotNull HttpServletRequest request) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Iterable $this$any$iv = this.excludedUrls;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String string = request.getRequestURI();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRequestURI(...)");
                    CharSequence charSequence = string;
                    if (!new Regex(it).matches(charSequence)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    protected void doFilterInternal(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response2, @NotNull FilterChain filterChain) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)filterChain, (String)"filterChain");
        switch (WhenMappings.$EnumSwitchMapping$0[this.tenancyService.getExternalSystemType().ordinal()]) {
            case 1: {
                this.resSpAuthFilterService.doFilterInternal(request, response2, filterChain);
                break;
            }
            case 2: {
                this.resPlatformAuthFilterService.doFilterInternal(request, response2, filterChain);
                break;
            }
            case 3: {
                this.resSpAuthFilterService.doFilterInternal(request, response2, filterChain);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }
}

