/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.form.internal.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kuali.research.grants.form.internal.assembler.GgFormFamiliesAssembler;
import org.kuali.research.grants.form.internal.model.FormDetailsModel;
import org.kuali.research.grants.form.internal.service.FormDetailsService;
import org.kuali.research.grants.ggintegration.FormSearchRestClient;
import org.kuali.research.grants.ggintegration.GgForm;
import org.kuali.research.grants.ggintegration.GgFormFamily;
import org.kuali.research.grants.ggintegration.GgFormSearchParams;
import org.kuali.research.grants.ggintegration.GgFormSearchResults;
import org.kuali.research.grants.ggintegration.GgFormSet;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u001e\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0012J(\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/kuali/research/grants/form/internal/service/FormDetailsServiceImpl;", "Lorg/kuali/research/grants/form/internal/service/FormDetailsService;", "formSearchRestClient", "Lorg/kuali/research/grants/ggintegration/FormSearchRestClient;", "ggFormFamiliesAssembler", "Lorg/kuali/research/grants/form/internal/assembler/GgFormFamiliesAssembler;", "<init>", "(Lorg/kuali/research/grants/ggintegration/FormSearchRestClient;Lorg/kuali/research/grants/form/internal/assembler/GgFormFamiliesAssembler;)V", "getFormDetails", "Lorg/kuali/research/grants/form/internal/model/FormDetailsModel;", "id", "", "name", "", "version", "details", "predicate", "Lkotlin/Function1;", "Lorg/kuali/research/grants/ggintegration/GgForm;", "", "getDistinctFormsAndFamilies", "", "", "Lorg/kuali/research/grants/ggintegration/GgFormFamily;", "results", "Lorg/kuali/research/grants/ggintegration/GgFormSearchResults;", "research-grants-backend"})
@SourceDebugExtension(value={"SMAP\nFormDetailsServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FormDetailsServiceImpl.kt\norg/kuali/research/grants/form/internal/service/FormDetailsServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,46:1\n1617#2,9:47\n1869#2:56\n1870#2:58\n1626#2:59\n1374#2:63\n1460#2,5:64\n1374#2:69\n1460#2,2:70\n1563#2:72\n1634#2,3:73\n1462#2,3:76\n1504#2:79\n1534#2,3:80\n1537#2,3:90\n1#3:57\n1#3:62\n183#4,2:60\n382#5,7:83\n*S KotlinDebug\n*F\n+ 1 FormDetailsServiceImpl.kt\norg/kuali/research/grants/form/internal/service/FormDetailsServiceImpl\n*L\n28#1:47,9\n28#1:56\n28#1:58\n28#1:59\n41#1:63\n41#1:64,5\n42#1:69\n42#1:70,2\n42#1:72\n42#1:73,3\n42#1:76,3\n43#1:79\n43#1:80,3\n43#1:90,3\n28#1:57\n33#1:60,2\n43#1:83,7\n*E\n"})
public class FormDetailsServiceImpl
implements FormDetailsService {
    @NotNull
    private final FormSearchRestClient formSearchRestClient;
    @NotNull
    private final GgFormFamiliesAssembler ggFormFamiliesAssembler;

    public FormDetailsServiceImpl(@NotNull FormSearchRestClient formSearchRestClient, @NotNull GgFormFamiliesAssembler ggFormFamiliesAssembler) {
        Intrinsics.checkNotNullParameter((Object)formSearchRestClient, (String)"formSearchRestClient");
        Intrinsics.checkNotNullParameter((Object)ggFormFamiliesAssembler, (String)"ggFormFamiliesAssembler");
        this.formSearchRestClient = formSearchRestClient;
        this.ggFormFamiliesAssembler = ggFormFamiliesAssembler;
    }

    @Nullable
    public FormDetailsModel getFormDetails(int id) {
        return this.details(arg_0 -> FormDetailsServiceImpl.getFormDetails$lambda$0(id, arg_0));
    }

    @Nullable
    public FormDetailsModel getFormDetails(@NotNull String name, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return this.details(arg_0 -> FormDetailsServiceImpl.getFormDetails$lambda$1(name, version, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private FormDetailsModel details(Function1<? super GgForm, Boolean> predicate) {
        FormDetailsModel formDetailsModel;
        Object v0;
        block4: {
            Iterator $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = GgFormSet.INSTANCE.getALL_FORMS();
            FormDetailsServiceImpl formDetailsServiceImpl = this;
            boolean $i$f$mapNotNull = false;
            void var5_6 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                GgFormSearchResults it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (this.formSearchRestClient.search(new GgFormSearchParams(null, it, null, 5, null)) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Sequence $this$firstOrNull$iv = MapsKt.asSequence((Map)formDetailsServiceImpl.getDistinctFormsAndFamilies((List)destination$iv$iv));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl = false;
                GgForm ggForm = (GgForm)entry.getKey();
                if (!((Boolean)predicate.invoke((Object)ggForm)).booleanValue()) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        if (entry != null) {
            Map.Entry it = entry;
            boolean bl = false;
            Map.Entry entry2 = it;
            formDetailsModel = this.ggFormFamiliesAssembler.toModel(new Pair(entry2.getKey(), entry2.getValue()));
        } else {
            formDetailsModel = null;
        }
        return formDetailsModel;
    }

    /*
     * WARNING - void declaration
     */
    private Map<GgForm, List<GgFormFamily>> getDistinctFormsAndFamilies(List<GgFormSearchResults> results) {
        void $this$groupByTo$iv$iv;
        Iterable list$iv$iv;
        GgFormSearchResults it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = results;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (GgFormSearchResults)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getFamilies();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            GgFormFamily family = (GgFormFamily)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = family.getForms();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void form;
                GgForm ggForm = (GgForm)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(TuplesKt.to((Object)form, (Object)family));
            }
            list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it2;
            Object object;
            it = (Pair)element$iv$iv;
            boolean $i$a$-groupBy-FormDetailsServiceImpl$getDistinctFormsAndFamilies$52 = false;
            GgForm key$iv$iv = (GgForm)it.getFirst();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            Pair $i$a$-groupBy-FormDetailsServiceImpl$getDistinctFormsAndFamilies$52 = (Pair)element$iv$iv;
            Iterable iterable3 = list$iv$iv;
            boolean bl = false;
            iterable3.add((GgFormFamily)it2.getSecond());
        }
        return destination$iv$iv;
    }

    private static final boolean getFormDetails$lambda$0(int $id, GgForm it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getId(), (Object)String.valueOf($id));
    }

    private static final boolean getFormDetails$lambda$1(String $name, String $version, GgForm it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getName(), (Object)$name) && Intrinsics.areEqual((Object)it.getVersion(), (Object)$version);
    }
}

