/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.proposal.internal.service;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kuali.research.grants.ggintegration.FormSearchRestClient;
import org.kuali.research.grants.proposal.internal.dto.PropOppPackageUpsertDto;
import org.kuali.research.grants.proposal.internal.dto.PropOppPkgAssistanceListingUpsertDto;
import org.kuali.research.grants.proposal.internal.dto.PropOppPkgFormUpsertDto;
import org.kuali.research.grants.proposal.internal.dto.PropOppPkgSubmissionOptionsUpsertDto;
import org.kuali.research.grants.proposal.internal.entity.File;
import org.kuali.research.grants.proposal.internal.entity.PropOppPackage;
import org.kuali.research.grants.proposal.internal.entity.PropOppPkgAssistanceListing;
import org.kuali.research.grants.proposal.internal.entity.PropOppPkgForm;
import org.kuali.research.grants.proposal.internal.entity.PropOppPkgSchema;
import org.kuali.research.grants.proposal.internal.entity.PropOppPkgSubmissionOptions;
import org.kuali.research.grants.proposal.internal.entity.RevisionType;
import org.kuali.research.grants.proposal.internal.entity.SubmissionType;
import org.kuali.research.grants.proposal.internal.repository.PropOppPackageRepository;
import org.kuali.research.grants.proposal.internal.repository.RevisionTypeRepository;
import org.kuali.research.grants.proposal.internal.repository.SubmissionTypeRepository;
import org.kuali.research.grants.proposal.internal.service.PropOppPackageService;
import org.kuali.research.grants.proposal.internal.util.Error;
import org.kuali.research.grants.sys.file.FileUtils;
import org.kuali.research.grants.sys.util.Level;
import org.kuali.research.grants.sys.xml.SchemaFetcherService;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ%\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J)\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ'\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0017\u00a2\u0006\u0004\b \u0010!J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010\"\u001a\u00020&2\u0006\u0010$\u001a\u00020'H\u0016J\u0010\u0010\"\u001a\u00020(2\u0006\u0010$\u001a\u00020)H\u0016J;\u0010*\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0\u00100+2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b-\u0010.JK\u0010/\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u000100\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0\u00100+2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00101\u001a\u00020\u001a2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016\u00a2\u0006\u0004\b6\u00107R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/kuali/research/grants/proposal/internal/service/PropOppPackageServiceImpl;", "Lorg/kuali/research/grants/proposal/internal/service/PropOppPackageService;", "Lorg/apache/logging/log4j/kotlin/Logging;", "repository", "Lorg/kuali/research/grants/proposal/internal/repository/PropOppPackageRepository;", "submissionTypeRepository", "Lorg/kuali/research/grants/proposal/internal/repository/SubmissionTypeRepository;", "revisionTypeRepository", "Lorg/kuali/research/grants/proposal/internal/repository/RevisionTypeRepository;", "formSearchRestClient", "Lorg/kuali/research/grants/ggintegration/FormSearchRestClient;", "schemaFetcherService", "Lorg/kuali/research/grants/sys/xml/SchemaFetcherService;", "<init>", "(Lorg/kuali/research/grants/proposal/internal/repository/PropOppPackageRepository;Lorg/kuali/research/grants/proposal/internal/repository/SubmissionTypeRepository;Lorg/kuali/research/grants/proposal/internal/repository/RevisionTypeRepository;Lorg/kuali/research/grants/ggintegration/FormSearchRestClient;Lorg/kuali/research/grants/sys/xml/SchemaFetcherService;)V", "getAllByProposalIdAndPropOpportunityId", "", "Lorg/kuali/research/grants/proposal/internal/entity/PropOppPackage;", "proposalId", "Lorg/kuali/research/grants/proposal/internal/util/ProposalId;", "propOpportunityId", "Lorg/kuali/research/grants/proposal/internal/util/PropOpportunityId;", "getAllByProposalIdAndPropOpportunityId-ED88gEo", "(JJ)Ljava/util/List;", "getPropOppPackageById", "propOppPackageId", "Lorg/kuali/research/grants/proposal/internal/util/PropOppPackageId;", "getPropOppPackageById-MZ9uceU", "(JJJ)Lorg/kuali/research/grants/proposal/internal/entity/PropOppPackage;", "createOrUpdatePropOppPackage", "propOppPackageUpsertDto", "Lorg/kuali/research/grants/proposal/internal/dto/PropOppPackageUpsertDto;", "createOrUpdatePropOppPackage-Zfh2DEQ", "(JJLorg/kuali/research/grants/proposal/internal/dto/PropOppPackageUpsertDto;)Lorg/kuali/research/grants/proposal/internal/entity/PropOppPackage;", "upsertToEntity", "Lorg/kuali/research/grants/proposal/internal/entity/PropOppPkgAssistanceListing;", "upsertDto", "Lorg/kuali/research/grants/proposal/internal/dto/PropOppPkgAssistanceListingUpsertDto;", "Lorg/kuali/research/grants/proposal/internal/entity/PropOppPkgForm;", "Lorg/kuali/research/grants/proposal/internal/dto/PropOppPkgFormUpsertDto;", "Lorg/kuali/research/grants/proposal/internal/entity/PropOppPkgSubmissionOptions;", "Lorg/kuali/research/grants/proposal/internal/dto/PropOppPkgSubmissionOptionsUpsertDto;", "deletePropOppPackage", "Lkotlin/Pair;", "Lorg/kuali/research/grants/proposal/internal/util/Error;", "deletePropOppPackage-MZ9uceU", "(JJJ)Lkotlin/Pair;", "getPropOppPkgSchemaById", "Lorg/kuali/research/grants/proposal/internal/entity/File;", "packageId", "schemaId", "Lorg/kuali/research/grants/proposal/internal/util/PropOppPackageSchemaId;", "id", "Lorg/kuali/research/grants/proposal/internal/util/PropOppPackageSchemaFileId;", "getPropOppPkgSchemaById-KCyDLa4", "(JJJJJ)Lkotlin/Pair;", "research-grants-backend"})
@SourceDebugExtension(value={"SMAP\nPropOppPackageServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropOppPackageServiceImpl.kt\norg/kuali/research/grants/proposal/internal/service/PropOppPackageServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n*L\n1#1,207:1\n1563#2:208\n1634#2,3:209\n1563#2:212\n1634#2,3:213\n95#3:216\n135#3,3:217\n126#4:220\n153#4,3:221\n1#5:224\n30#6:225\n30#6:226\n30#6:227\n*S KotlinDebug\n*F\n+ 1 PropOppPackageServiceImpl.kt\norg/kuali/research/grants/proposal/internal/service/PropOppPackageServiceImpl\n*L\n88#1:208\n88#1:209,3\n92#1:212\n92#1:213,3\n95#1:216\n95#1:217,3\n102#1:220\n102#1:221,3\n165#1:225\n174#1:226\n200#1:227\n*E\n"})
public class PropOppPackageServiceImpl
implements PropOppPackageService,
Logging {
    @NotNull
    private final PropOppPackageRepository repository;
    @NotNull
    private final SubmissionTypeRepository submissionTypeRepository;
    @NotNull
    private final RevisionTypeRepository revisionTypeRepository;
    @NotNull
    private final FormSearchRestClient formSearchRestClient;
    @NotNull
    private final SchemaFetcherService schemaFetcherService;

    public PropOppPackageServiceImpl(@NotNull PropOppPackageRepository repository, @NotNull SubmissionTypeRepository submissionTypeRepository, @NotNull RevisionTypeRepository revisionTypeRepository, @NotNull FormSearchRestClient formSearchRestClient, @NotNull SchemaFetcherService schemaFetcherService) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)submissionTypeRepository, (String)"submissionTypeRepository");
        Intrinsics.checkNotNullParameter((Object)revisionTypeRepository, (String)"revisionTypeRepository");
        Intrinsics.checkNotNullParameter((Object)formSearchRestClient, (String)"formSearchRestClient");
        Intrinsics.checkNotNullParameter((Object)schemaFetcherService, (String)"schemaFetcherService");
        this.repository = repository;
        this.submissionTypeRepository = submissionTypeRepository;
        this.revisionTypeRepository = revisionTypeRepository;
        this.formSearchRestClient = formSearchRestClient;
        this.schemaFetcherService = schemaFetcherService;
    }

    @NotNull
    public List<PropOppPackage> getAllByProposalIdAndPropOpportunityId-ED88gEo(long proposalId, long propOpportunityId) {
        return this.repository.findByProposalIdAndPropOpportunityId(proposalId, propOpportunityId);
    }

    @Nullable
    public PropOppPackage getPropOppPackageById-MZ9uceU(long proposalId, long propOpportunityId, long propOppPackageId) {
        return (PropOppPackage)OptionalsKt.getOrNull((Optional)this.repository.findByProposalIdAndPropOpportunityIdAndId(proposalId, propOpportunityId, propOppPackageId));
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public PropOppPackage createOrUpdatePropOppPackage-Zfh2DEQ(long proposalId, long propOpportunityId, @NotNull PropOppPackageUpsertDto propOppPackageUpsertDto) {
        PropOppPkgSubmissionOptions propOppPkgSubmissionOptions;
        PropOppPkgSubmissionOptionsUpsertDto $this$mapTo$iv$iv;
        void $this$map$iv;
        PropOppPkgFormUpsertDto p0;
        Collection collection;
        Iterable $this$mapTo$iv$iv2;
        Iterable $this$map$iv2;
        Intrinsics.checkNotNullParameter((Object)propOppPackageUpsertDto, (String)"propOppPackageUpsertDto");
        if (propOppPackageUpsertDto.getLinked()) {
            this.repository.findSingleByProposalIdAndLinkedTrue(proposalId, propOpportunityId).ifPresent(arg_0 -> PropOppPackageServiceImpl.createOrUpdatePropOppPackage_Zfh2DEQ$lambda$1(arg_0 -> PropOppPackageServiceImpl.createOrUpdatePropOppPackage_Zfh2DEQ$lambda$0(propOppPackageUpsertDto, this, arg_0), arg_0));
        }
        PropOppPackage propOppPackage = new PropOppPackage(propOppPackageUpsertDto.getId(), propOppPackageUpsertDto.getPackageId(), propOppPackageUpsertDto.getCompetitionId(), propOppPackageUpsertDto.getCompetitionTitle(), !propOppPackageUpsertDto.isNih(), propOppPackageUpsertDto.getOpeningDate(), propOppPackageUpsertDto.getClosingDate(), propOppPackageUpsertDto.getProvider(), propOppPackageUpsertDto.getSchemaUrl(), propOppPackageUpsertDto.getInstructionsUrl(), propOppPackageUpsertDto.getLinked(), Long.valueOf(propOpportunityId), null, null, null, null, null, null, null, 520192, null);
        Iterable iterable = propOppPackageUpsertDto.getAssistanceListings();
        Object object = propOppPackage;
        boolean $i$f$map = false;
        void var9_9 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            PropOppPkgAssistanceListingUpsertDto propOppPkgAssistanceListingUpsertDto = (PropOppPkgAssistanceListingUpsertDto)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.upsertToEntity((PropOppPkgAssistanceListingUpsertDto)p0));
        }
        object.addAllAssistanceListings((List)destination$iv$iv);
        $this$map$iv2 = propOppPackageUpsertDto.getForms();
        object = propOppPackage;
        $i$f$map = false;
        $this$mapTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            p0 = (PropOppPkgFormUpsertDto)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.upsertToEntity(p0));
        }
        object.addAllForms((List)destination$iv$iv);
        boolean $i$f$measureTimedValue22 = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        String string = propOppPackage.getSchemaUrl().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Map result$iv$iv = this.schemaFetcherService.fetchSchemas(string);
        TimedValue result = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        boolean $i$a$-let-PropOppPackageServiceImpl$createOrUpdatePropOppPackage$schemas$32 = false;
        this.getLogger().info((CharSequence)("Fetched ALL schemas from grants.gov for package " + propOppPackage.getPackageId() + " in " + Duration.toString-impl((long)result.getDuration-UwyO8pc())));
        Map $i$f$measureTimedValue22 = (Map)result.getValue();
        boolean $i$f$map2 = false;
        void $i$a$-let-PropOppPackageServiceImpl$createOrUpdatePropOppPackage$schemas$32 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo2 = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            byte[] bytes;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            object = destination$iv$iv2;
            boolean bl2 = false;
            String namespace = (String)entry.getKey();
            Resource schemaResource = (Resource)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)schemaResource.getContentAsByteArray(), (String)"getContentAsByteArray(...)");
            object.add(new PropOppPkgSchema(null, namespace, new File(null, FileUtils.INSTANCE.sanitizeFileNmae(namespace, ".xsd"), "application/xml", (long)bytes.length, bytes, null, null, 96, null), null, null, null, 56, null));
        }
        List schemas = (List)destination$iv$iv2;
        propOppPackage.addAllSchemas(schemas);
        PropOppPackage propOppPackage2 = propOppPackage;
        PropOppPkgSubmissionOptionsUpsertDto propOppPkgSubmissionOptionsUpsertDto = propOppPackageUpsertDto.getSubmissionOptions();
        if (propOppPkgSubmissionOptionsUpsertDto != null) {
            void it;
            $this$mapTo$iv$iv = propOppPkgSubmissionOptionsUpsertDto;
            object = propOppPackage2;
            boolean bl3 = false;
            propOppPkgSubmissionOptions = this.upsertToEntity((PropOppPkgSubmissionOptionsUpsertDto)it);
            propOppPackage2 = object;
        } else {
            propOppPkgSubmissionOptions = null;
        }
        propOppPackage2.setSubmissionOptions(propOppPkgSubmissionOptions);
        Object object2 = this.repository.save((Object)propOppPackage);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"save(...)");
        return (PropOppPackage)object2;
    }

    @NotNull
    public PropOppPkgAssistanceListing upsertToEntity(@NotNull PropOppPkgAssistanceListingUpsertDto upsertDto) {
        Intrinsics.checkNotNullParameter((Object)upsertDto, (String)"upsertDto");
        return new PropOppPkgAssistanceListing(upsertDto.getId(), upsertDto.getAlNumber(), upsertDto.getTitle(), null, null, null, 56, null);
    }

    @NotNull
    public PropOppPkgForm upsertToEntity(@NotNull PropOppPkgFormUpsertDto upsertDto) {
        Intrinsics.checkNotNullParameter((Object)upsertDto, (String)"upsertDto");
        Long l = upsertDto.getId();
        String string = upsertDto.getName();
        String string2 = upsertDto.getFormVersion();
        boolean bl = upsertDto.getMandatory();
        boolean bl2 = upsertDto.getInclude();
        URL uRL = this.formSearchRestClient.schemaUrl(-1, upsertDto.getName(), upsertDto.getFormVersion());
        return new PropOppPkgForm(l, string, string2, uRL, bl, bl2, null, null, null, 448, null);
    }

    @NotNull
    public PropOppPkgSubmissionOptions upsertToEntity(@NotNull PropOppPkgSubmissionOptionsUpsertDto upsertDto) {
        RevisionType revisionType;
        SubmissionType submissionType;
        Intrinsics.checkNotNullParameter((Object)upsertDto, (String)"upsertDto");
        Long l = upsertDto.getSubmissionTypeId();
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            Optional optional = this.submissionTypeRepository.findById((Object)it);
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"findById(...)");
            submissionType = (SubmissionType)OptionalsKt.getOrNull((Optional)optional);
        } else {
            submissionType = null;
        }
        SubmissionType submissionType2 = submissionType;
        Long l2 = upsertDto.getRevisionTypeId();
        if (l2 != null) {
            long it = ((Number)l2).longValue();
            boolean bl = false;
            Optional optional = this.revisionTypeRepository.findById((Object)it);
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"findById(...)");
            revisionType = (RevisionType)OptionalsKt.getOrNull((Optional)optional);
        } else {
            revisionType = null;
        }
        RevisionType revisionType2 = revisionType;
        return new PropOppPkgSubmissionOptions(upsertDto.getId(), submissionType2, revisionType2, null, null, null, 56, null);
    }

    @NotNull
    public Pair<PropOppPackage, List<Error>> deletePropOppPackage-MZ9uceU(long proposalId, long propOpportunityId, long propOppPackageId) {
        Pair pair;
        PropOppPackage packageToDelete = this.getPropOppPackageById-MZ9uceU(proposalId, propOpportunityId, propOppPackageId);
        if (packageToDelete == null) {
            String message = "No package found for proposal " + proposalId + " and opportunity " + propOpportunityId + " and packge " + propOppPackageId;
            PropOppPackageServiceImpl $this$logger$iv = this;
            boolean $i$f$logger = false;
            LoggingFactoryKt.loggerOf(PropOppPackageServiceImpl.class).error((CharSequence)message);
            return TuplesKt.to(null, (Object)CollectionsKt.listOf((Object)new Error(message, Level.SEVERE)));
        }
        try {
            this.repository.delete((Object)packageToDelete);
            pair = TuplesKt.to((Object)packageToDelete, (Object)CollectionsKt.emptyList());
        }
        catch (Exception e) {
            String message = "Failed to delete package with id " + propOppPackageId;
            PropOppPackageServiceImpl $this$logger$iv = this;
            boolean $i$f$logger = false;
            LoggingFactoryKt.loggerOf(PropOppPackageServiceImpl.class).error((CharSequence)message, (Throwable)e);
            TuplesKt.to((Object)packageToDelete, (Object)CollectionsKt.listOf((Object)new Error("Failed to delete package: " + e.getMessage(), Level.SEVERE)));
            pair = TuplesKt.to(null, (Object)CollectionsKt.listOf((Object)new Error(message, Level.SEVERE)));
        }
        return pair;
    }

    @NotNull
    public Pair<File, List<Error>> getPropOppPkgSchemaById-KCyDLa4(long proposalId, long propOpportunityId, long packageId, long schemaId, long id) {
        Optional file = this.repository.findSchemaFileByProposalIdAndPropOpportunityIdAndPropOppPackageIdAndAndSchemaIdAndId(proposalId, propOpportunityId, packageId, schemaId, id);
        if (file.isEmpty()) {
            String message = "No schema file found for file " + id + " and proposal " + proposalId + ", opportunity " + propOpportunityId + ", package " + packageId + ", schema " + schemaId;
            PropOppPackageServiceImpl $this$logger$iv = this;
            boolean $i$f$logger = false;
            LoggingFactoryKt.loggerOf(PropOppPackageServiceImpl.class).error((CharSequence)message);
            return TuplesKt.to(null, (Object)CollectionsKt.listOf((Object)new Error(message, Level.SEVERE)));
        }
        return TuplesKt.to(file.get(), (Object)CollectionsKt.emptyList());
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }

    private static final Unit createOrUpdatePropOppPackage_Zfh2DEQ$lambda$0(PropOppPackageUpsertDto $propOppPackageUpsertDto, PropOppPackageServiceImpl this$0, PropOppPackage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!Intrinsics.areEqual((Object)$propOppPackageUpsertDto.getId(), (Object)it.getId())) {
            this$0.repository.save((Object)PropOppPackage.copy$default((PropOppPackage)it, null, null, null, null, (boolean)false, null, null, null, null, null, (boolean)false, null, null, null, null, null, null, null, null, (int)523263, null));
            this$0.repository.flush();
        }
        return Unit.INSTANCE;
    }

    private static final void createOrUpdatePropOppPackage_Zfh2DEQ$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

