/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.sys.rest.internal;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.client.UnknownContentTypeException;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@RestControllerAdvice
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0017J\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\n\u0010\u000b\u001a\u00060\fj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000b\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0017\u00a8\u0006\u0012"}, d2={"Lorg/kuali/research/grants/sys/rest/internal/GlobalRestExceptionHandler;", "Lorg/springframework/web/servlet/mvc/method/annotation/ResponseEntityExceptionHandler;", "Lorg/apache/logging/log4j/kotlin/Logging;", "<init>", "()V", "handleConstraintViolationException", "Lorg/springframework/http/ResponseEntity;", "", "e", "Ljakarta/validation/ConstraintViolationException;", "handleGlobalException", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "request", "Lorg/springframework/web/context/request/WebRequest;", "handleUnknownContentTypeException", "Lorg/springframework/web/client/UnknownContentTypeException;", "research-grants-backend"})
public class GlobalRestExceptionHandler
extends ResponseEntityExceptionHandler
implements Logging {
    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @NotNull
    public ResponseEntity<Object> handleConstraintViolationException(@NotNull ConstraintViolationException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        HttpStatusCode httpStatusCode = (HttpStatusCode)HttpStatus.BAD_REQUEST;
        Set set = e.getConstraintViolations();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getConstraintViolations(...)");
        return new ResponseEntity((Object)ProblemDetail.forStatusAndDetail((HttpStatusCode)httpStatusCode, (String)CollectionsKt.joinToString$default((Iterable)set, null, null, null, (int)0, null, GlobalRestExceptionHandler::handleConstraintViolationException$lambda$0, (int)31, null)), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={Exception.class})
    @NotNull
    public ResponseEntity<Object> handleGlobalException(@NotNull Exception ex, @NotNull WebRequest request) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR)).build();
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"build(...)");
        return responseEntity;
    }

    @ExceptionHandler(value={UnknownContentTypeException.class})
    @NotNull
    public ResponseEntity<Object> handleUnknownContentTypeException(@NotNull UnknownContentTypeException ex, @NotNull WebRequest request) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR)).build();
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"build(...)");
        return responseEntity;
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }

    private static final CharSequence handleConstraintViolationException$lambda$0(ConstraintViolation it) {
        return it.getPropertyPath() + " " + it.getMessage() + "\n";
    }
}

