-- V1__create_proposal_submission_revision_opportunity_tables.sql
CREATE TABLE PROPOSAL (
  id SERIAL PRIMARY KEY,
  principal_investigator VARCHAR(255),
  proposal_number VARCHAR(255) NOT NULL,
  sponsor_name VARCHAR(255),
  title VARCHAR(255) NOT NULL
);

CREATE TABLE OPPORTUNITY (
  id SERIAL PRIMARY KEY,
  opportunity_number VARCHAR(255) NOT NULL,
  opportunity_title VARCHAR(255) NOT NULL,
  linked BOOLEAN DEFAULT true,
  proposal_id INTEGER NOT NULL,
  CONSTRAINT fk_proposal FOREIGN KEY (proposal_id) REFERENCES PROPOSAL (id)
);

CREATE TABLE OPPORTUNITY_PACKAGE (
  id SERIAL PRIMARY KEY,
  gg_package_id VARCHAR(255) NOT NULL,
  competition_id VARCHAR(255),
  competition_title VARCHAR(255),
  opening_date DATE,
  closing_date DATE,
  provider VARCHAR(255) NOT NULL,
  schema_url VARCHAR(255) NOT NULL,
  instructions_url VARCHAR(255),
  linked BOOLEAN NOT NULL,
  opportunity_id INTEGER NOT NULL,
  CONSTRAINT fk_opportunity FOREIGN KEY (opportunity_id) REFERENCES OPPORTUNITY (id)
);

CREATE TABLE OPPORTUNITY_PACKAGE_ASSISTANCE_LISTING (
  id SERIAL PRIMARY KEY,
  al_number VARCHAR(255) NOT NULL,
  title VARCHAR(255),
  opportunity_package_id INTEGER NOT NULL,
  CONSTRAINT fk_opportunity_package FOREIGN KEY (opportunity_package_id) REFERENCES OPPORTUNITY_PACKAGE (id)
);

CREATE TABLE OPPORTUNITY_PACKAGE_FORM (
  id SERIAL PRIMARY KEY,
  name VARCHAR(255) NOT NULL,
  version INTEGER NOT NULL,
  mandatory BOOLEAN NOT NULL,
  opportunity_package_id INTEGER NOT NULL,
  CONSTRAINT fk_opportunity_package_form FOREIGN KEY (opportunity_package_id) REFERENCES OPPORTUNITY_PACKAGE (id)
);

CREATE TABLE SUBMISSION_OPTIONS (
  id SERIAL PRIMARY KEY,
  opportunity_package_id INTEGER NOT NULL,
  submission_type_id INTEGER NOT NULL,
  revision_type_id INTEGER NOT NULL,
  CONSTRAINT fk_opportunity_package_submission FOREIGN KEY (opportunity_package_id) REFERENCES OPPORTUNITY_PACKAGE (id),
  CONSTRAINT fk_submission_type FOREIGN KEY (submission_type_id) REFERENCES SUBMISSION_TYPE (id),
  CONSTRAINT fk_revision_type FOREIGN KEY (revision_type_id) REFERENCES REVISION_TYPE (id)
);

ALTER TABLE submission_type
RENAME COLUMN "key" TO code;

ALTER TABLE submission_type
RENAME COLUMN value TO description;

ALTER TABLE revision_type
RENAME COLUMN "key" TO code;

ALTER TABLE revision_type
RENAME COLUMN value TO description;
