/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.resintegration.sp.auth.internal.service;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.grants.resintegration.sp.auth.ResSpAuthUser;
import org.kuali.research.grants.resintegration.sp.auth.SpAuthBearerToken;
import org.kuali.research.grants.resintegration.sp.auth.internal.service.ResSpMutableAuthService;
import org.kuali.research.grants.resintegration.sp.auth.internal.service.ResSpMutableAuthServiceImpl;
import org.kuali.research.grants.sys.jwt.JwtService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0017\u0018\u00002\u00020\u0001:\u0001\u001dB#\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0016J\u001c\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0016J\u001c\u0010\u0019\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0012J\b\u0010\u001a\u001a\u00020\u0017H\u0016J\u000f\u0010\u001b\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lorg/kuali/research/grants/resintegration/sp/auth/internal/service/ResSpMutableAuthServiceImpl;", "Lorg/kuali/research/grants/resintegration/sp/auth/internal/service/ResSpMutableAuthService;", "spSystemToSystemSecret", "", "spSystemToSystemExpirationSeconds", "", "jwtService", "Lorg/kuali/research/grants/sys/jwt/JwtService;", "<init>", "(Ljava/lang/String;JLorg/kuali/research/grants/sys/jwt/JwtService;)V", "getSpSystemToSystemSecret", "()Ljava/lang/String;", "getSpSystemToSystemExpirationSeconds", "()J", "getJwtService", "()Lorg/kuali/research/grants/sys/jwt/JwtService;", "isSet", "", "authUser", "Lkotlin/Pair;", "Lorg/kuali/research/grants/resintegration/sp/auth/SpAuthBearerToken;", "Lorg/kuali/research/grants/resintegration/sp/auth/ResSpAuthUser;", "setAuthUser", "", "resSpAuthUser", "setAuthUserUnsafe", "removeAuthUser", "system2SystemToken", "system2SystemToken-NzKCt_M", "AuthUserState", "research-grants-backend"})
public class ResSpMutableAuthServiceImpl
implements ResSpMutableAuthService {
    @NotNull
    private final String spSystemToSystemSecret;
    private final long spSystemToSystemExpirationSeconds;
    @NotNull
    private final JwtService jwtService;

    public ResSpMutableAuthServiceImpl(@Value(value="${kuali.sp.auth.server2service.secret}") @NotNull String spSystemToSystemSecret, @Value(value="${kuali.sp.auth.server2service.expiration.seconds}") long spSystemToSystemExpirationSeconds, @NotNull JwtService jwtService) {
        Intrinsics.checkNotNullParameter((Object)spSystemToSystemSecret, (String)"spSystemToSystemSecret");
        Intrinsics.checkNotNullParameter((Object)jwtService, (String)"jwtService");
        this.spSystemToSystemSecret = spSystemToSystemSecret;
        this.spSystemToSystemExpirationSeconds = spSystemToSystemExpirationSeconds;
        this.jwtService = jwtService;
    }

    @NotNull
    public String getSpSystemToSystemSecret() {
        return this.spSystemToSystemSecret;
    }

    public long getSpSystemToSystemExpirationSeconds() {
        return this.spSystemToSystemExpirationSeconds;
    }

    @NotNull
    public JwtService getJwtService() {
        return this.jwtService;
    }

    public boolean isSet() {
        return AuthUserState.INSTANCE.getResSpAuthUsers().get() != null;
    }

    @NotNull
    public Pair<SpAuthBearerToken, ResSpAuthUser> authUser() {
        Pair pair = (Pair)AuthUserState.INSTANCE.getResSpAuthUsers().get();
        if (pair == null) {
            throw new IllegalStateException("auth user not set");
        }
        return pair;
    }

    public void setAuthUser(@NotNull Pair<SpAuthBearerToken, ResSpAuthUser> resSpAuthUser) {
        Intrinsics.checkNotNullParameter(resSpAuthUser, (String)"resSpAuthUser");
        this.setAuthUserUnsafe(resSpAuthUser);
    }

    private void setAuthUserUnsafe(Pair<SpAuthBearerToken, ResSpAuthUser> resSpAuthUser) {
        AuthUserState.INSTANCE.getResSpAuthUsers().set(resSpAuthUser);
    }

    public void removeAuthUser() {
        AuthUserState.INSTANCE.getResSpAuthUsers().remove();
    }

    @NotNull
    public String system2SystemToken-NzKCt_M() {
        return SpAuthBearerToken.constructor-impl((String)this.getJwtService().createToken(this.getSpSystemToSystemSecret(), this.getSpSystemToSystemExpirationSeconds()));
    }
}

