/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2019 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.util;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.apache.ojb.broker.metadata.ConnectionRepository;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.DefaultResourceLoader;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class OjbMetadataLoader implements InitializingBean {
    
    private static final Logger LOG = LogManager.getLogger(OjbMetadataLoader.class);

    private List<String> repositoryDescriptors = new ArrayList<String>();
    private List<String> connectionDescriptors = new ArrayList<String>(); 
    
    public List<String> getConnectionDescriptors() {
        return connectionDescriptors;
    }

    public void setConnectionDescriptors(List<String> connectionDescriptors) {
        this.connectionDescriptors = connectionDescriptors;
    }

    public List<String> getRepositoryDescriptors() {
        return repositoryDescriptors;
    }

    public void setRepositoryDescriptors(List<String> repositoryDescriptors) {
        this.repositoryDescriptors = repositoryDescriptors;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        
        MetadataManager mm = MetadataManager.getInstance();
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader(ClassLoaderUtils.getDefaultClassLoader());
        
        for (String repositoryDescriptor : repositoryDescriptors) {
            InputStream is = resourceLoader.getResource(repositoryDescriptor).getInputStream();
            DescriptorRepository dr = mm.readDescriptorRepository(is);
            mm.mergeDescriptorRepository(dr);
            if (LOG.isDebugEnabled()) {
                LOG.debug("--------------------------------------------------------------------------");
                LOG.debug("Merging repository descriptor: " + repositoryDescriptor);
                LOG.debug("--------------------------------------------------------------------------");
            }
            try {
                is.close();
            } catch (Exception e) {
                LOG.warn("Failed to close stream to file " + repositoryDescriptor, e);
            }
        }
        
        for (String connectionDesciptor : connectionDescriptors) {
            InputStream is = resourceLoader.getResource(connectionDesciptor).getInputStream();
            ConnectionRepository cr = mm.readConnectionRepository(is);
            mm.mergeConnectionRepository(cr);
            if (LOG.isDebugEnabled()) {
                LOG.debug("--------------------------------------------------------------------------");
                LOG.debug("Merging connection descriptor: " + connectionDesciptor);
                LOG.debug("--------------------------------------------------------------------------");
            }
            try {
                is.close();
            } catch (Exception e) {
                LOG.warn("Failed to close stream to file " + connectionDesciptor, e);
            }
        }
        
    }

}
