/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2019 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

/**
 * Builds a <code>{@link String}</code> instance using a pattern similar to the varargs printf() variety.
 * 
 * 
 */
public class PatternedStringBuilder {
    private String _pattern;

    /**
     * Constructor that takes a pattern
     * 
     * @param pattern
     */
    public PatternedStringBuilder(String pattern) {
        setPattern(pattern);
    }

    /**
     * Write accessor method for pattern
     * 
     * @param pattern
     */
    public void setPattern(String pattern) {
        _pattern = pattern;
    }

    /**
     * Read accessor method for pattern
     * 
     * @return String
     */
    public String getPattern() {
        return _pattern;
    }

    /**
     * Takes an ellipses of <code>{@link String}</code> parameters and builds a <code>{@link String}</code> instance from them
     * and the pattern given earlier.
     * 
     * @param args
     * @return String
     */
    public String sprintf(Object... args) {
        ByteArrayOutputStream retval = new ByteArrayOutputStream();

        new PrintStream(retval).printf(getPattern(), args);

        return retval.toString();
    }
}
