/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.jaxb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.kuali.rice.core.util.jaxb.RiceXmlExportList;
import org.kuali.rice.core.util.jaxb.RiceXmlImportList;
import org.kuali.rice.core.util.jaxb.RiceXmlListAdditionListener;
import org.kuali.rice.core.util.jaxb.RiceXmlListGetterListener;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.api.permission.PermissionContract;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.jaxb.RolePermissionXmlDTO;
import org.kuali.rice.kim.impl.jaxb.RoleXmlDTO;
import org.kuali.rice.kim.impl.jaxb.RoleXmlUtil;

@XmlTransient
public abstract class RolePermissionsXmlDTO<T extends RolePermissionXmlDTO>
implements RiceXmlListAdditionListener<T>,
Serializable {
    private static final long serialVersionUID = 1L;

    public abstract List<T> getRolePermissions();

    public abstract void setRolePermissions(List<T> var1);

    void beforeUnmarshal(Unmarshaller unmarshaller, Object parent) throws UnmarshalException {
        this.setRolePermissions(new RiceXmlImportList(this));
    }

    void afterUnmarshal(Unmarshaller unmarshaller, Object parent) throws UnmarshalException {
        this.setRolePermissions(null);
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="RolePermissionsType", propOrder={"rolePermissions"})
    public static class WithinRole
    extends RolePermissionsXmlDTO<RolePermissionXmlDTO.WithinRole>
    implements RiceXmlListGetterListener<RolePermissionXmlDTO.WithinRole, String> {
        private static final long serialVersionUID = 1L;
        @XmlElement(name="rolePermission")
        private List<RolePermissionXmlDTO.WithinRole> rolePermissions;
        @XmlTransient
        private String roleId;

        public WithinRole() {
        }

        public WithinRole(String roleId) {
            this.roleId = roleId;
        }

        @Override
        public List<RolePermissionXmlDTO.WithinRole> getRolePermissions() {
            return this.rolePermissions;
        }

        @Override
        public void setRolePermissions(List<RolePermissionXmlDTO.WithinRole> rolePermissions) {
            this.rolePermissions = rolePermissions;
        }

        public String getRoleId() {
            return this.roleId;
        }

        @Override
        void beforeUnmarshal(Unmarshaller unmarshaller, Object parent) throws UnmarshalException {
            if (parent instanceof RoleXmlDTO) {
                RoleXmlDTO parentRole = (RoleXmlDTO)parent;
                if (!parentRole.isAlreadyPersisted()) {
                    RoleXmlUtil.validateAndPersistNewRole(parentRole);
                }
                this.roleId = parentRole.getRoleId();
            }
            super.beforeUnmarshal(unmarshaller, parent);
        }

        @Override
        public void newItemAdded(RolePermissionXmlDTO.WithinRole item) {
            try {
                RoleXmlUtil.validateAndPersistNewRolePermission(item);
            }
            catch (UnmarshalException e) {
                throw new RuntimeException(e);
            }
        }

        void beforeMarshal(Marshaller marshaller) {
            ArrayList permissionIds = new ArrayList();
            if (permissionIds != null && !permissionIds.isEmpty()) {
                this.setRolePermissions((List<RolePermissionXmlDTO.WithinRole>)new RiceXmlExportList<RolePermissionXmlDTO.WithinRole, String>(permissionIds, this));
            }
        }

        void afterMarshal(Marshaller marshaller) {
            this.setRolePermissions((List<RolePermissionXmlDTO.WithinRole>)null);
        }

        @Override
        public RolePermissionXmlDTO.WithinRole gettingNextItem(String nextItem, int index) {
            Permission permission = KimApiServiceLocator.getPermissionService().getPermission(nextItem);
            if (permission == null) {
                throw new RuntimeException("Cannot find permission with ID \"" + nextItem + "\"");
            }
            return new RolePermissionXmlDTO.WithinRole((PermissionContract)permission, false);
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="StandaloneRolePermissionsType", propOrder={"rolePermissions"})
    public static class OutsideOfRole
    extends RolePermissionsXmlDTO<RolePermissionXmlDTO.OutsideOfRole> {
        private static final long serialVersionUID = 1L;
        @XmlElement(name="rolePermission")
        private List<RolePermissionXmlDTO.OutsideOfRole> rolePermissions;

        @Override
        public List<RolePermissionXmlDTO.OutsideOfRole> getRolePermissions() {
            return this.rolePermissions;
        }

        @Override
        public void setRolePermissions(List<RolePermissionXmlDTO.OutsideOfRole> rolePermissions) {
            this.rolePermissions = rolePermissions;
        }

        @Override
        public void newItemAdded(RolePermissionXmlDTO.OutsideOfRole item) {
            try {
                RoleXmlUtil.validateAndPersistNewRolePermission(item);
            }
            catch (UnmarshalException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

