/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper;

import japa.parser.ast.CompilationUnit;
import japa.parser.ast.ImportDeclaration;
import japa.parser.ast.Node;
import japa.parser.ast.body.BodyDeclaration;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.FieldDeclaration;
import japa.parser.ast.body.TypeDeclaration;
import japa.parser.ast.body.VariableDeclarator;
import japa.parser.ast.expr.AnnotationExpr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.AnnotationResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.Level;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.NodeData;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.VoidVisitorHelperBase;

public class AnnotationHelper
extends VoidVisitorHelperBase<String> {
    private static final Log LOG = LogFactory.getLog(AnnotationHelper.class);
    private final Collection<AnnotationResolver> resolvers;
    private final boolean removeExisting;

    public AnnotationHelper(Collection<AnnotationResolver> resolvers, boolean removeExisting) {
        this.resolvers = resolvers;
        this.removeExisting = removeExisting;
    }

    @Override
    public void visitPre(ClassOrInterfaceDeclaration n, String mappedClass) {
        this.addAnnotation((BodyDeclaration)n, mappedClass, Level.CLASS);
    }

    @Override
    public void visitPre(FieldDeclaration n, String mappedClass) {
        this.addAnnotation((BodyDeclaration)n, mappedClass, Level.FIELD);
    }

    private CompilationUnit getCompilationUnit(Node n) {
        Node unit;
        for (unit = n; !(unit instanceof CompilationUnit) && unit != null; unit = unit.getParentNode()) {
        }
        return (CompilationUnit)unit;
    }

    private void addAnnotation(BodyDeclaration n, String mappedClass, Level level) {
        for (AnnotationResolver resolver : this.resolvers) {
            NodeData nodes;
            if (resolver.getLevel() != level) continue;
            LOG.debug((Object)("Evaluating resolver " + ClassUtils.getShortClassName(resolver.getClass()) + " for " + this.getTypeOrFieldNameForMsg(n) + "."));
            String fullyQualifiedName = resolver.getFullyQualifiedName();
            CompilationUnit unit = this.getCompilationUnit((Node)n);
            List imports = unit.getImports() != null ? unit.getImports() : new ArrayList();
            boolean foundAnnImport = this.imported(imports, fullyQualifiedName);
            AnnotationExpr existingAnnotation = this.findAnnotation(n, fullyQualifiedName, foundAnnImport);
            if (this.removeExisting && existingAnnotation != null) {
                LOG.info((Object)("removing existing " + existingAnnotation + " from " + this.getTypeOrFieldNameForMsg(n) + "."));
                List annotations = n.getAnnotations() != null ? n.getAnnotations() : new ArrayList();
                annotations.remove(existingAnnotation);
                n.setAnnotations(annotations);
            }
            if (existingAnnotation != null && (existingAnnotation == null || !this.removeExisting) || (nodes = resolver.resolve((Node)n, mappedClass)) == null || nodes.annotation == null) continue;
            LOG.info((Object)("adding " + nodes.annotation + " to " + this.getTypeOrFieldNameForMsg(n) + "."));
            List annotations = n.getAnnotations() != null ? n.getAnnotations() : new ArrayList();
            annotations.add(nodes.annotation);
            n.setAnnotations(annotations);
            if (!foundAnnImport) {
                LOG.info((Object)("adding import " + fullyQualifiedName + " to " + this.getTypeNameForMsg((Node)n) + "."));
                imports.add(nodes.annotationImport);
            }
            if (nodes.additionalImports != null) {
                for (ImportDeclaration aImport : nodes.additionalImports) {
                    if (aImport.isStatic() || aImport.isAsterisk()) {
                        throw new IllegalStateException("The additional imports should not be static or star imports");
                    }
                    boolean imported = this.imported(imports, aImport.getName().toString());
                    if (imported) continue;
                    LOG.info((Object)("adding import " + aImport.getName().toString() + " to " + this.getTypeNameForMsg((Node)n) + "."));
                    imports.add(aImport);
                }
            }
            unit.setImports(imports);
            if (nodes.nestedDeclaration == null) continue;
            TypeDeclaration parent = (TypeDeclaration)unit.getTypes().get(0);
            List members = parent.getMembers() != null ? parent.getMembers() : new ArrayList();
            TypeDeclaration existingNestedDeclaration = this.findTypeDeclaration(members, nodes.nestedDeclaration.getName());
            if (this.removeExisting && existingNestedDeclaration != null) {
                LOG.info((Object)("removing existing nested declaration " + existingNestedDeclaration.getName() + " from " + this.getTypeOrFieldNameForMsg(n) + "."));
                members.remove(existingNestedDeclaration);
            }
            if (existingNestedDeclaration == null || existingNestedDeclaration != null && this.removeExisting) {
                nodes.nestedDeclaration.setParentNode((Node)parent);
                LOG.info((Object)("adding nested declaration " + nodes.nestedDeclaration.getName() + " to " + this.getTypeOrFieldNameForMsg(n) + "."));
                members.add(nodes.nestedDeclaration);
            }
            parent.setMembers(members);
        }
    }

    private AnnotationExpr findAnnotation(BodyDeclaration n, String fullyQualifiedName, boolean foundAnnImport) {
        String simpleName = ClassUtils.getShortClassName((String)fullyQualifiedName);
        List annotations = n.getAnnotations() != null ? n.getAnnotations() : new ArrayList();
        for (AnnotationExpr ae : annotations) {
            String name = ae.getName().toString();
            if (simpleName.equals(name) && foundAnnImport) {
                LOG.info((Object)("found " + ae + " on " + this.getTypeOrFieldNameForMsg(n) + "."));
                return ae;
            }
            if (!fullyQualifiedName.equals(name)) continue;
            LOG.info((Object)("found " + ae + " on " + this.getTypeOrFieldNameForMsg(n) + "."));
            return ae;
        }
        return null;
    }

    private TypeDeclaration findTypeDeclaration(List<BodyDeclaration> members, String name) {
        if (members != null) {
            for (BodyDeclaration bd : members) {
                if (!(bd instanceof TypeDeclaration) || !((TypeDeclaration)bd).getName().equals(name)) continue;
                return (TypeDeclaration)bd;
            }
        }
        return null;
    }

    private boolean imported(List<ImportDeclaration> imports, String fullyQualifiedName) {
        String packageName = ClassUtils.getPackageName((String)fullyQualifiedName);
        for (ImportDeclaration i : imports) {
            if (i.isStatic()) continue;
            String importName = i.getName().toString();
            if (i.isAsterisk()) {
                if (!packageName.equals(importName)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("found import " + packageName + ".* on " + this.getTypeNameForMsg((Node)i) + "."));
                }
                return true;
            }
            if (!fullyQualifiedName.equals(importName)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("found import " + fullyQualifiedName + " on " + this.getTypeNameForMsg((Node)i) + "."));
            }
            return true;
        }
        return false;
    }

    private String getTypeOrFieldNameForMsg(BodyDeclaration n) {
        if (n instanceof TypeDeclaration) {
            return ((TypeDeclaration)n).getName();
        }
        if (n instanceof FieldDeclaration) {
            FieldDeclaration fd = (FieldDeclaration)n;
            CompilationUnit unit = this.getCompilationUnit((Node)n);
            TypeDeclaration parent = (TypeDeclaration)unit.getTypes().get(0);
            ArrayList<String> variableNames = new ArrayList<String>();
            if (fd.getVariables() != null) {
                for (VariableDeclarator vd : fd.getVariables()) {
                    variableNames.add(vd.getId().getName());
                }
            }
            return variableNames.size() == 1 ? parent.getName() + "." + (String)variableNames.iterator().next() : parent.getName() + "." + ((Object)variableNames).toString();
        }
        return null;
    }

    private String getTypeNameForMsg(Node n) {
        CompilationUnit unit = this.getCompilationUnit(n);
        TypeDeclaration parent = (TypeDeclaration)unit.getTypes().get(0);
        return parent.getName();
    }
}

