/**
 * Copyright 2005-2016 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.rice.core.framework.persistence.jpa;

import java.io.Serializable;
import java.util.Properties;

import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;

/**
 * This is a subclass of Hibernate's SequenceStyleGenerator that will convert sequence-generated or table-generated numeric IDs into Strings.
 * 
 * TODO: Make sure this generator works with MySQL, and verify that the correct numeric Hibernate Type is being used in the configure() method override.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class RiceNumericStringSequenceStyleGenerator extends SequenceStyleGenerator {

	/**
	 * Performs the same configuration operations as those of the superclass, except that the provided Type will be replaced by Hibernate's LongType instead.
	 * 
	 * TODO: Should we add a configuration parameter for allowing users to specify a different supported Hibernate numeric Type if desired?
	 * 
	 * @see org.hibernate.id.enhanced.SequenceStyleGenerator#configure(org.hibernate.type.Type, java.util.Properties, org.hibernate.dialect.Dialect)
	 */
	@Override
	public void configure(Type type, Properties params, Dialect dialect)
			throws MappingException {
		super.configure(new LongType(), params, dialect);
	}
	
	/**
	 * Takes the ID generated by the superclass's version of this method and returns its toString() representation instead.
	 * 
	 * @see org.hibernate.id.enhanced.SequenceStyleGenerator#generate(org.hibernate.engine.SessionImplementor, java.lang.Object)
	 */
	@Override
	public Serializable generate(SessionImplementor session, Object object) {
		return super.generate(session, object).toString();
	}
}
