/**
 * Copyright 2005-2016 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package edu.sampleu.travel.service;

import java.util.Map;

import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;

import edu.sampleu.travel.dto.FiscalOfficerInfo;
import org.kuali.rice.kns.inquiry.KualiInquirableImpl;

/**
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class FiscalOfficerInfoInquiryViewHelperServiceImpl extends KualiInquirableImpl {
    
    @Override
    public FiscalOfficerInfo retrieveDataObject(Map fieldValues) {
        FiscalOfficerService service = GlobalResourceLoader.getService("fiscalOfficerService");
        
        return service.retrieveFiscalOfficer(new Long((String)fieldValues.get("id")));
    }

}
