/**
 * Copyright 2005-2016 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.rice.krad.uif

def currentDir = new File(".");

def inputFile = new File("cssReplacements.txt");
def replaceMap = new HashMap();

inputFile.splitEachLine(',') {fields ->
  replaceMap.put(fields[0], fields[1]);
}

def backupFile;
def fileText;

currentDir.eachFileRecurse(
  {file ->
      if (file.isFile() && file.name.endsWith(".css") && !file.name.startsWith("jquery")) {
        fileText = file.text;
        replaceMap.each{
            fileText = fileText.replace(it.key, it.value);
        }
        file.write(fileText);
    }
  }
);