/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.registry.Plugin;
import org.apache.maven.plugin.registry.PluginRegistry;
import org.apache.maven.plugin.registry.RuntimeInfo;

public final class PluginRegistryUtils {
    private PluginRegistryUtils() {
    }

    public static void merge(PluginRegistry dominant, PluginRegistry recessive, String recessiveSourceLevel) {
        String recessiveAutoUpdate;
        String dominantAutoUpdate;
        String recessiveUpdateInterval;
        if (dominant == null || recessive == null) {
            return;
        }
        RuntimeInfo dominantRtInfo = dominant.getRuntimeInfo();
        String dominantUpdateInterval = dominant.getUpdateInterval();
        if (dominantUpdateInterval == null && (recessiveUpdateInterval = recessive.getUpdateInterval()) != null) {
            dominant.setUpdateInterval(recessiveUpdateInterval);
            dominantRtInfo.setUpdateIntervalSourceLevel(recessiveSourceLevel);
        }
        if ((dominantAutoUpdate = dominant.getAutoUpdate()) == null && (recessiveAutoUpdate = recessive.getAutoUpdate()) != null) {
            dominant.setAutoUpdate(recessiveAutoUpdate);
            dominantRtInfo.setAutoUpdateSourceLevel(recessiveSourceLevel);
        }
        List<Plugin> recessivePlugins = null;
        recessivePlugins = recessive != null ? recessive.getPlugins() : Collections.EMPTY_LIST;
        PluginRegistryUtils.shallowMergePlugins(dominant, recessivePlugins, recessiveSourceLevel);
    }

    public static void recursivelySetSourceLevel(PluginRegistry pluginRegistry, String sourceLevel) {
        if (pluginRegistry == null) {
            return;
        }
        pluginRegistry.setSourceLevel(sourceLevel);
        for (Plugin plugin : pluginRegistry.getPlugins()) {
            plugin.setSourceLevel(sourceLevel);
        }
    }

    private static void shallowMergePlugins(PluginRegistry dominant, List recessive, String recessiveSourceLevel) {
        Map dominantByKey = dominant.getPluginsByKey();
        List<Plugin> dominantPlugins = dominant.getPlugins();
        for (Plugin recessivePlugin : recessive) {
            if (dominantByKey.containsKey(recessivePlugin.getKey())) continue;
            recessivePlugin.setSourceLevel(recessiveSourceLevel);
            dominantPlugins.add(recessivePlugin);
        }
        dominant.flushPluginsByKey();
    }

    public static PluginRegistry extractUserPluginRegistry(PluginRegistry pluginRegistry) {
        PluginRegistry userRegistry = null;
        if (pluginRegistry != null && !"global-level".equals(pluginRegistry.getSourceLevel())) {
            userRegistry = new PluginRegistry();
            RuntimeInfo rtInfo = new RuntimeInfo(userRegistry);
            userRegistry.setRuntimeInfo(rtInfo);
            RuntimeInfo oldRtInfo = pluginRegistry.getRuntimeInfo();
            if ("user-level".equals(oldRtInfo.getAutoUpdateSourceLevel())) {
                userRegistry.setAutoUpdate(pluginRegistry.getAutoUpdate());
            }
            if ("user-level".equals(oldRtInfo.getUpdateIntervalSourceLevel())) {
                userRegistry.setUpdateInterval(pluginRegistry.getUpdateInterval());
            }
            ArrayList<Plugin> plugins = new ArrayList<Plugin>();
            for (Plugin plugin : pluginRegistry.getPlugins()) {
                if (!"user-level".equals(plugin.getSourceLevel())) continue;
                plugins.add(plugin);
            }
            userRegistry.setPlugins(plugins);
            rtInfo.setFile(pluginRegistry.getRuntimeInfo().getFile());
        }
        return userRegistry;
    }
}

