/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.framework.workflow;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Timer;
import java.util.TimerTask;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.util.xml.XmlException;
import org.kuali.rice.core.api.util.xml.XmlJotter;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.document.DocumentContent;
import org.kuali.rice.kew.framework.postprocessor.ActionTakenEvent;
import org.kuali.rice.kew.framework.postprocessor.DeleteEvent;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteLevelChange;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kew.framework.postprocessor.ProcessDocReport;
import org.kuali.rice.kew.postprocessor.DefaultPostProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class EDocLitePostProcessor
extends DefaultPostProcessor {
    private static final Logger LOG = LogManager.getLogger(EDocLitePostProcessor.class);
    private static final Timer TIMER = new Timer();
    public static final int SUBMIT_URL_MILLISECONDS_WAIT = 60000;
    public static final String EVENT_TYPE_ACTION_TAKEN = "actionTaken";
    public static final String EVENT_TYPE_DELETE_ROUTE_HEADER = "deleteRouteHeader";
    public static final String EVENT_TYPE_ROUTE_LEVEL_CHANGE = "routeLevelChange";
    public static final String EVENT_TYPE_ROUTE_STATUS_CHANGE = "statusChange";

    private static String getURL(Document edlDoc) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        return (String)xpath.evaluate("//edlContent/edl/eventNotificationURL", edlDoc, XPathConstants.STRING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void submitURL(String urlstring, Document eventDoc) throws IOException {
        String content;
        try {
            content = XmlJotter.jotNode((Node)eventDoc, (boolean)true);
        }
        catch (XmlException te) {
            LOG.error("Error writing serializing event doc: " + eventDoc);
            throw te;
        }
        byte[] contentBytes = content.getBytes("UTF-8");
        LOG.debug("submitURL: " + urlstring);
        URL url = new URL(urlstring);
        String message = "POST " + url.getFile() + " HTTP/1.0\r\n" + "Content-Length: " + contentBytes.length + "\r\n" + "Cache-Control: no-cache\r\n" + "Pragma: no-cache\r\n" + "User-Agent: Java/1.4.2; EDocLitePostProcessor\r\n" + "Host: " + url.getHost() + "\r\n" + "Connection: close\r\n" + "Content-Type: application/x-www-form-urlencoded\r\n\r\n" + content;
        byte[] buf = message.getBytes("UTF-8");
        Socket s = new Socket(url.getHost(), url.getPort());
        OutputStream os = s.getOutputStream();
        try {
            try {
                os.write(buf, 0, buf.length);
                os.flush();
            }
            catch (InterruptedIOException ioe) {
                LOG.error("IO was interrupted while posting event to url " + urlstring + ": " + ioe.getMessage());
            }
            catch (IOException ioe) {
                LOG.error("Error posting EDocLite content to url " + urlstring + ioe.getMessage());
            }
            finally {
                try {
                    LOG.debug("Shutting down output stream");
                    s.shutdownOutput();
                }
                catch (IOException ioe) {
                    LOG.error("Error shutting down output stream for url " + urlstring + ": " + ioe.getMessage());
                }
            }
            InputStream is = s.getInputStream();
            try {
                buf = new byte[1024];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int read = is.read(buf);
                if (read != -1) {
                    baos.write(buf, 0, read);
                }
                LOG.debug("EDocLite post processor response:\n" + new String(baos.toByteArray()));
            }
            catch (InterruptedIOException ioe) {
                LOG.error("IO was interrupted while reading response from url " + urlstring + ": " + ioe.getMessage());
            }
            catch (IOException ioe) {
                LOG.error("Error reading response from EDocLite handler url " + urlstring + ioe.getMessage());
            }
            finally {
                try {
                    LOG.debug("Shutting down input stream");
                    s.shutdownInput();
                }
                catch (IOException ioe) {
                    LOG.error("Error shutting down input stream for url " + urlstring + ": " + ioe.getMessage());
                }
            }
        }
        finally {
            try {
                s.close();
            }
            catch (IOException ioe) {
                LOG.error("Error closing socket", (Throwable)ioe);
            }
        }
    }

    protected static void postEvent(String docId, Object event, String eventName) {
        try {
            String urlstring;
            Document doc = EDocLitePostProcessor.getEDLContent(docId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Submitting doc: " + XmlJotter.jotNode((Node)doc));
            }
            if (StringUtils.isEmpty((String)(urlstring = EDocLitePostProcessor.getURL(doc)))) {
                LOG.warn("No eventNotificationURL defined in EDLContent");
                return;
            }
            Document eventDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element eventE = eventDoc.createElement("event");
            eventE.setAttribute("type", eventName);
            eventDoc.appendChild(eventE);
            Element infoE = (Element)eventDoc.importNode(EDocLitePostProcessor.propertiesToXml(event, "info"), true);
            Element docIdE = eventDoc.createElement("docId");
            docIdE.appendChild(eventDoc.createTextNode(String.valueOf(docId)));
            infoE.appendChild(docIdE);
            eventE.appendChild(infoE);
            eventE.appendChild(eventDoc.importNode(doc.getDocumentElement(), true));
            String query = "docId=" + docId;
            urlstring = urlstring.indexOf(63) != -1 ? urlstring + "&" + query : urlstring + "?" + query;
            final String _urlstring = urlstring;
            final Document _eventDoc = eventDoc;
            final Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        LOG.debug("Post Event calling url: " + _urlstring);
                        EDocLitePostProcessor.submitURL(_urlstring, _eventDoc);
                        LOG.debug("Post Event done calling url: " + _urlstring);
                    }
                    catch (Exception e) {
                        LOG.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
            t.setDaemon(true);
            t.start();
            TIMER.schedule(new TimerTask(){

                @Override
                public void run() {
                    t.interrupt();
                }
            }, 60000L);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public ProcessDocReport doRouteStatusChange(DocumentRouteStatusChange event) throws RemoteException {
        LOG.debug("doRouteStatusChange: " + event);
        EDocLitePostProcessor.postEvent(event.getDocumentId(), event, EVENT_TYPE_ROUTE_STATUS_CHANGE);
        return new ProcessDocReport(true, "");
    }

    public ProcessDocReport doActionTaken(ActionTakenEvent event) throws RemoteException {
        LOG.debug("doActionTaken: " + event);
        EDocLitePostProcessor.postEvent(event.getDocumentId(), event, EVENT_TYPE_ACTION_TAKEN);
        return new ProcessDocReport(true, "");
    }

    public ProcessDocReport doDeleteRouteHeader(DeleteEvent event) throws RemoteException {
        LOG.debug("doDeleteRouteHeader: " + event);
        EDocLitePostProcessor.postEvent(event.getDocumentId(), event, EVENT_TYPE_DELETE_ROUTE_HEADER);
        return new ProcessDocReport(true, "");
    }

    public ProcessDocReport doRouteLevelChange(DocumentRouteLevelChange event) throws RemoteException {
        LOG.debug("doRouteLevelChange: " + event);
        EDocLitePostProcessor.postEvent(event.getDocumentId(), event, EVENT_TYPE_ROUTE_LEVEL_CHANGE);
        return new ProcessDocReport(true, "");
    }

    public static Document getEDLContent(String documentId) {
        try {
            DocumentContent documentContent = KewApiServiceLocator.getWorkflowDocumentService().getDocumentContent(documentId);
            String content = documentContent.getFullContent();
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(content)));
            return doc;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static DocumentBuilder getDocumentBuilder() throws Exception {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder();
    }

    private static String lowerCaseFirstChar(String s) {
        if (s.length() == 0 || Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length());
        sb.append(Character.toLowerCase(s.charAt(0)));
        if (s.length() > 1) {
            sb.append(s.substring(1));
        }
        return sb.toString();
    }

    public static Element propertiesToXml(Object o, String elementName) throws Exception {
        Class<?> c = o.getClass();
        Document doc = EDocLitePostProcessor.getDocumentBuilder().newDocument();
        Element wrapper = doc.createElement(elementName);
        Method[] methods = c.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String name = methods[i].getName();
            if ("getClass".equals(name) || !name.startsWith("get") || methods[i].getParameterTypes().length > 0) continue;
            name = name.substring("get".length());
            name = EDocLitePostProcessor.lowerCaseFirstChar(name);
            String value = null;
            try {
                Object result = methods[i].invoke(o, null);
                if (result == null) {
                    LOG.debug("value of " + name + " method on object " + o.getClass() + " is null");
                    value = "";
                } else {
                    value = result.toString();
                }
                Element fieldE = doc.createElement(name);
                fieldE.appendChild(doc.createTextNode(value));
                wrapper.appendChild(fieldE);
                continue;
            }
            catch (RuntimeException e) {
                LOG.error("Error accessing method '" + methods[i].getName() + " of instance of " + c, (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                LOG.error("Error accessing method '" + methods[i].getName() + " of instance of " + c, (Throwable)e);
            }
        }
        return wrapper;
    }
}

