/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl.extract;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Version;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.edl.framework.extract.FieldDTO;
import org.kuali.rice.edl.impl.extract.Dump;
import org.kuali.rice.krad.service.KRADServiceLocator;

@Entity
@Table(name="KREW_EDL_FLD_DMP_T")
public class Fields {
    private static final long serialVersionUID = -6136544551121011531L;
    @Id
    @GeneratedValue(generator="KREW_EDL_FLD_DMP_S")
    @GenericGenerator(name="KREW_EDL_FLD_DMP_S", strategy="org.hibernate.id.enhanced.SequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KREW_EDL_FLD_DMP_S"), @Parameter(name="value_column", value="id")})
    @Column(name="EDL_FIELD_DMP_ID")
    private Long fieldId;
    @Column(name="DOC_HDR_ID")
    private String docId;
    @Column(name="FLD_NM")
    private String fieldName;
    @Column(name="FLD_VAL")
    private String fieldValue;
    @Version
    @Column(name="VER_NBR")
    private Integer lockVerNbr;
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST})
    @JoinColumn(name="DOC_HDR_ID", insertable=false, updatable=false)
    private Dump dump;

    public void beforeInsert() {
        OrmUtils.populateAutoIncValue((Object)this, (EntityManager)KRADServiceLocator.getEntityManagerFactory().createEntityManager());
    }

    public Long getFieldId() {
        return this.fieldId;
    }

    public String getDocId() {
        return this.docId;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    public String getFieldValue() {
        return this.fieldValue;
    }

    public void setFieldValue(String fieldValue) {
        this.fieldValue = fieldValue;
    }

    public String getFiledName() {
        return this.fieldName;
    }

    public void setFieldName(String filedName) {
        this.fieldName = filedName;
    }

    public Integer getLockVerNbr() {
        return this.lockVerNbr;
    }

    public void setLockVerNbr(Integer lockVerNbr) {
        this.lockVerNbr = lockVerNbr;
    }

    public Dump getDump() {
        return this.dump;
    }

    public void setDump(Dump dump) {
        this.dump = dump;
    }

    public static FieldDTO to(Fields field) {
        if (field == null) {
            return null;
        }
        FieldDTO fieldDTO = new FieldDTO();
        fieldDTO.setDocId(field.getDocId());
        fieldDTO.setFieldName(field.getFiledName());
        fieldDTO.setFieldValue(field.getFieldValue());
        fieldDTO.setLockVerNbr(field.getLockVerNbr());
        return fieldDTO;
    }

    public static Fields from(FieldDTO fieldDTO, Dump dump) {
        if (fieldDTO == null) {
            return null;
        }
        Fields fields = new Fields();
        fields.setDump(dump);
        fields.setDocId(fieldDTO.getDocId());
        fields.setFieldName(fieldDTO.getFiledName());
        fields.setFieldValue(fieldDTO.getFieldValue());
        fields.setLockVerNbr(fieldDTO.getLockVerNbr());
        return fields;
    }
}

