/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine.node;

import java.util.HashMap;
import java.util.Map;

/**
 * The current context of a search process within a node graph.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class NodeGraphContext {

	private RouteNodeInstance previousNodeInstance;
    private RouteNodeInstance currentNodeInstance;
    private RouteNodeInstance resultNodeInstance;
    private Map<String, RouteNodeInstance> visited = new HashMap<String, RouteNodeInstance>();
    private Map<String, Integer> splitState = new HashMap<String, Integer>();
    
    public RouteNodeInstance getCurrentNodeInstance() {
        return currentNodeInstance;
    }
    public void setCurrentNodeInstance(RouteNodeInstance currentNodeInstance) {
        this.currentNodeInstance = currentNodeInstance;
    }
    public RouteNodeInstance getPreviousNodeInstance() {
        return previousNodeInstance;
    }
    public void setPreviousNodeInstance(RouteNodeInstance previousNodeInstance) {
        this.previousNodeInstance = previousNodeInstance;
    }
    public RouteNodeInstance getResultNodeInstance() {
        return resultNodeInstance;
    }
    public void setResultNodeInstance(RouteNodeInstance resultNodeInstance) {
        this.resultNodeInstance = resultNodeInstance;
    }
    public Map<String, Integer> getSplitState() {
        return splitState;
    }
    public void setSplitState(Map<String, Integer> splitState) {
        this.splitState = splitState;
    }
    public Map<String, RouteNodeInstance> getVisited() {
        return visited;
    }
    public void setVisited(Map<String, RouteNodeInstance> visited) {
        this.visited = visited;
    }

}
