/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.rule;

import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.kns.web.ui.Row;

import java.util.Collections;
import java.util.List;
import java.util.Map;



/**
 * Abstract base class for {@link WorkflowRuleAttribute}s.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public abstract class AbstractWorkflowAttribute implements WorkflowRuleAttribute {
    protected boolean required;

    @Override
    public List<Row> getRuleRows() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<Row> getRoutingDataRows() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public String getDocContent() {
        return "";
    }

    @Override
    public List<RuleExtensionValue> getRuleExtensionValues() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<RemotableAttributeError> validateRoutingData(Map paramMap) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<RemotableAttributeError> validateRuleData(Map paramMap) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public boolean isRequired() {
        return required;
    }

    /* TODO: document these two methods ... what are these for? */
    public String getIdFieldName() {
        return "";
    }
    public String getLockFieldName() {
        return "";
    }
}
