/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.lookup;

import java.util.*;

import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.KRADPropertyConstants;

/**
 * The LookupResultsSupportStrategyService implementation which supports PersistableBusinessObjects, simply enough 
 *
 * @deprecated Only used by KNS classes, use KRAD.
 */
@Deprecated
public class PersistableBusinessObjectLookupResultsSupportStrategyImpl
		implements LookupResultsSupportStrategyService {
	
	private BusinessObjectService businessObjectService;

	/**
	 * Returns the object id
	 */
	@Override
    public String getLookupIdForBusinessObject(BusinessObject businessObject) {
		PersistableBusinessObject pbo = (PersistableBusinessObject)businessObject;
		return pbo.getObjectId(); 
	}

	@Override
    public <T extends BusinessObject> Collection<T> retrieveSelectedResultBOs(Class<T> boClass, Set<String> lookupIds) {
		
        Map<String, Collection<String>> queryCriteria = new HashMap<>();
        queryCriteria.put(KRADPropertyConstants.OBJECT_ID, lookupIds);
        return (List<T>) getBusinessObjectService().findMatching((Class<PersistableBusinessObject>) boClass, queryCriteria);
	}

	/**
	 * Sees if the class implements the PersistableBusinessObject interface; if so, then yes, the BO qualifies!
	 */
	@Override
    public boolean qualifiesForStrategy(Class<? extends BusinessObject> boClass) {
		return PersistableBusinessObject.class.isAssignableFrom(boClass);
	}

	public BusinessObjectService getBusinessObjectService() {
		return this.businessObjectService;
	}

	public void setBusinessObjectService(BusinessObjectService businessObjectService) {
		this.businessObjectService = businessObjectService;
	}
}
