/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.deliverer.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.ken.bo.NotificationMessageDelivery;
import org.kuali.rice.ken.core.GlobalNotificationServiceLocator;
import org.kuali.rice.ken.deliverer.NotificationMessageDeliverer;
import org.kuali.rice.ken.exception.NotificationAutoRemoveException;
import org.kuali.rice.ken.exception.NotificationMessageDeliveryException;
import org.kuali.rice.ken.service.NotificationWorkflowDocumentService;
import org.kuali.rice.ken.util.Util;
import org.kuali.rice.kew.api.WorkflowDocument;

public class KEWActionListMessageDeliverer
implements NotificationMessageDeliverer {
    private static Logger LOG = LogManager.getLogger(KEWActionListMessageDeliverer.class);
    public static final String INTERNAL_COMMAND_FLAG = "internal_command";
    private NotificationWorkflowDocumentService notificationWorkflowDocumentService = GlobalNotificationServiceLocator.getInstance().getNotificationWorkflowDocumentService();

    @Override
    public void deliverMessage(NotificationMessageDelivery messageDelivery) throws NotificationMessageDeliveryException {
        String documentId = this.notificationWorkflowDocumentService.createAndAdHocRouteNotificationWorkflowDocument(messageDelivery, Util.getNotificationSystemUser(), messageDelivery.getUserRecipientId(), "The notification message has been delivered by the Notification System.");
        messageDelivery.setDeliverySystemId(documentId);
        LOG.debug("Message Delivery: " + messageDelivery.toString());
    }

    @Override
    public void autoRemoveMessageDelivery(NotificationMessageDelivery messageDelivery) throws NotificationAutoRemoveException {
        WorkflowDocument workflowDoc = null;
        String sysId = messageDelivery.getDeliverySystemId();
        if (sysId == null) {
            LOG.error("NotificationMessageDelivery " + messageDelivery.getId() + " is missing delivery system id (workflow document id");
            return;
        }
        workflowDoc = this.notificationWorkflowDocumentService.getNotificationWorkflowDocumentByDocumentId(messageDelivery.getUserRecipientId(), sysId);
        this.flagWorkflowDocument(workflowDoc);
        this.notificationWorkflowDocumentService.clearAllFyisAndAcknowledgeNotificationWorkflowDocument(messageDelivery.getUserRecipientId(), workflowDoc, "The notification message has been auto-removed by the Notification System.");
    }

    @Override
    public void dismissMessageDelivery(NotificationMessageDelivery messageDelivery, String user, String cause) {
        LOG.info("Dismissing as user '" + user + "' workflow document '" + messageDelivery.getDeliverySystemId() + "' corresponding to message delivery #" + messageDelivery.getId() + " due to cause: " + cause);
        if (!"autoremove".equals(cause)) {
            WorkflowDocument nwd = this.notificationWorkflowDocumentService.getNotificationWorkflowDocumentByDocumentId(user, messageDelivery.getDeliverySystemId());
            this.flagWorkflowDocument(nwd);
            if ("ack".equals(cause)) {
                if (nwd.isAcknowledgeRequested()) {
                    nwd.acknowledge("This notification has been acknowledged.");
                    LOG.debug("acknowledged " + nwd.getTitle());
                    LOG.debug("status display value: " + nwd.getStatus().getLabel());
                } else {
                    LOG.debug("Acknowledgement was not needed for document " + nwd.getDocumentId());
                }
            } else if ("fyi".equals(cause)) {
                if (nwd.isFYIRequested()) {
                    nwd.fyi();
                    LOG.debug("fyi " + nwd.getTitle());
                    LOG.debug("status display value: " + nwd.getStatus().getLabel());
                } else {
                    LOG.debug("FYI was not needed for document " + nwd.getDocumentId());
                }
            }
        }
    }

    protected void flagWorkflowDocument(WorkflowDocument doc) {
        Properties p = new Properties();
        p.setProperty(INTERNAL_COMMAND_FLAG, "true");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(100);
        try {
            p.store(baos, null);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not store properties", ioe);
        }
        doc.setAttributeContent("<whatever>" + new String(baos.toByteArray()) + "</whatever>");
    }
}

