/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.input.DOMBuilder;
import org.kuali.rice.core.api.util.xml.SafeXmlUtils;
import org.kuali.rice.kew.actionrequest.ActionRequestFactory;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.actions.CancelAction;
import org.kuali.rice.kew.actions.ReturnToPreviousNodeAction;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.action.ActionRequestPolicy;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.doctype.DocumentTypePolicy;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.role.KimRoleRecipient;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.xml.CommonXmlParser;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class RecallAction
extends ReturnToPreviousNodeAction {
    private static final Logger LOG = LogManager.getLogger(RecallAction.class);
    protected final boolean cancel;
    protected final Collection<Recipient> notificationRecipients;

    public RecallAction(DocumentRouteHeaderValue routeHeader, PrincipalContract principal) {
        this(routeHeader, principal, null, true, true, true);
    }

    public RecallAction(DocumentRouteHeaderValue routeHeader, PrincipalContract principal, String annotation, boolean cancel) {
        this(routeHeader, principal, annotation, cancel, true, true);
    }

    public RecallAction(DocumentRouteHeaderValue routeHeader, PrincipalContract principal, String annotation, boolean cancel, boolean sendNotifications) {
        this(routeHeader, principal, annotation, cancel, sendNotifications, true);
    }

    public RecallAction(DocumentRouteHeaderValue routeHeader, PrincipalContract principal, String annotation, boolean cancel, boolean sendNotifications, boolean runPostProcessorLogic) {
        super(ActionType.RECALL.getCode(), routeHeader, principal, principal.getPrincipalName() + " recalled document" + (String)(StringUtils.isBlank((String)annotation) ? "" : ": " + annotation), INITIAL_NODE_NAME, sendNotifications, runPostProcessorLogic);
        this.cancel = cancel;
        this.notificationRecipients = Collections.unmodifiableCollection(RecallAction.parseNotificationRecipients(routeHeader));
    }

    protected static Collection<Recipient> parseNotificationRecipients(DocumentRouteHeaderValue routeHeader) {
        String config;
        ArrayList<Recipient> toNotify = new ArrayList<Recipient>();
        org.kuali.rice.kew.doctype.DocumentTypePolicy recallNotification = routeHeader.getDocumentType().getRecallNotification();
        if (recallNotification != null && !StringUtils.isBlank((String)(config = recallNotification.getPolicyStringValue()))) {
            Document notificationConfig;
            try {
                notificationConfig = SafeXmlUtils.safeDocumentBuilderFactory().newDocumentBuilder().parse(new InputSource(new StringReader(config)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            DOMBuilder jdom = new DOMBuilder();
            NodeList recipients = notificationConfig.getDocumentElement().getElementsByTagName("recipients");
            for (int i = 0; i < recipients.getLength(); ++i) {
                NodeList children = recipients.item(i).getChildNodes();
                for (int j = 0; j < children.getLength(); ++j) {
                    Node n = children.item(j);
                    if (!(n instanceof Element)) continue;
                    Element e = (Element)n;
                    if ("role".equals(e.getNodeName())) {
                        String ns = e.getAttribute("namespace");
                        String name = e.getAttribute("name");
                        Role role = KimApiServiceLocator.getRoleService().getRoleByNamespaceCodeAndName(ns, name);
                        if (role == null) {
                            LOG.error("No role round: " + ns + ":" + name);
                            continue;
                        }
                        toNotify.add(new KimRoleRecipient(role));
                        continue;
                    }
                    org.jdom2.Element parent = new org.jdom2.Element("parent");
                    parent.addContent((Content)jdom.build((Element)e.cloneNode(true)).detach());
                    toNotify.add(CommonXmlParser.parseResponsibilityNameAndType(parent).getRecipient());
                }
            }
        }
        return toNotify;
    }

    @Override
    public String validateActionRules(List<ActionRequestValue> actionRequests) {
        if (!this.getRouteHeader().isValidActionToTake(this.getActionPerformedCode())) {
            return "Document of status '" + this.getRouteHeader().getDocRouteStatus() + "' cannot taken action '" + ActionType.fromCode((String)this.getActionTakenCode()).getLabel() + "' to node name " + this.nodeName;
        }
        String errMsg = this.validateActionsTaken(this.getRouteHeader());
        if (errMsg != null) {
            return errMsg;
        }
        errMsg = this.validateRouting(this.getRouteHeader());
        if (errMsg != null) {
            return errMsg;
        }
        if (!KEWServiceLocator.getDocumentTypePermissionService().canRecall(this.getPrincipal().getPrincipalId(), this.getRouteHeader())) {
            return "User is not authorized to Recall document";
        }
        return "";
    }

    protected String validateActionsTaken(DocumentRouteHeaderValue rh) {
        String validActionsTaken = rh.getDocumentType().getPolicyByName(DocumentTypePolicy.RECALL_VALID_ACTIONSTAKEN.getCode(), (String)null).getPolicyStringValue();
        if (StringUtils.isNotBlank((String)validActionsTaken)) {
            String[] validActionsTakenStrings = validActionsTaken.split("\\s*,\\s*");
            HashSet<ActionType> validActionTypes = new HashSet<ActionType>(validActionsTakenStrings.length);
            for (String s : validActionsTakenStrings) {
                ActionType at = ActionType.fromCodeOrLabel((String)s);
                if (at == null) {
                    throw new IllegalArgumentException("Failed to locate the ActionType with the given code or label: " + s);
                }
                validActionTypes.add(at);
            }
            Collection<ActionTakenValue> actionsTaken = KEWServiceLocator.getActionTakenService().findByDocumentId(this.getRouteHeader().getDocumentId());
            for (ActionTakenValue actionTaken : actionsTaken) {
                ActionType at = ActionType.fromCode((String)actionTaken.getActionTaken());
                if (validActionTypes.contains(at)) continue;
                return "Invalid prior action taken: '" + at.getLabel() + "'. Cannot Recall.";
            }
        }
        return null;
    }

    protected String validateRouting(DocumentRouteHeaderValue rh) {
        List processes = rh.getDocumentType().getProcesses();
        String errMsg = null;
        if (processes.size() == 0) {
            errMsg = "No processes are defined for document type. Recall is not applicable.";
        } else {
            RouteNode initialRouteNode = rh.getDocumentType().getPrimaryProcess().getInitialRouteNode();
            if (initialRouteNode.getName().equalsIgnoreCase("ADHOC") && initialRouteNode.getNextNodeIds().isEmpty()) {
                errMsg = "No non-adhoc route nodes defined for document type. Recall is not applicable";
            }
        }
        return errMsg;
    }

    @Override
    protected List<ActionRequestValue> findApplicableActionRequests(List<ActionRequestValue> actionRequests) {
        return actionRequests;
    }

    @Override
    public boolean isActionCompatibleRequest(List<ActionRequestValue> requests) {
        return true;
    }

    @Override
    protected ActionRequestType getReturnToInitiatorActionRequestType() {
        return ActionRequestType.COMPLETE;
    }

    @Override
    protected PrincipalContract determineInitialNodePrincipal(DocumentRouteHeaderValue routeHeader) {
        return this.getPrincipal();
    }

    @Override
    protected void sendAdditionalNotifications() {
        super.sendAdditionalNotifications();
        ActionRequestFactory arFactory = new ActionRequestFactory(this.routeHeader);
        for (Recipient recipient : this.notificationRecipients) {
            if (!(recipient instanceof KimRoleRecipient)) {
                arFactory.addRootActionRequest(ActionRequestType.FYI.getCode(), 0, recipient, "Document was recalled", "0", null, null, null);
                continue;
            }
            KimRoleRecipient kimRoleRecipient = (KimRoleRecipient)recipient;
            Map qualifications = Collections.emptyMap();
            LOG.info("Adding KIM Role Request for " + String.valueOf(kimRoleRecipient.getRole()));
            arFactory.addKimRoleRequest(ActionRequestType.FYI.getCode(), 0, kimRoleRecipient.getRole(), KimApiServiceLocator.getRoleService().getRoleMembers(Collections.singletonList(kimRoleRecipient.getRole().getId()), qualifications), "Document was recalled", "0", true, ActionRequestPolicy.FIRST.getCode(), "Document was recalled");
        }
        this.getActionRequestService().activateRequests(arFactory.getRequestGraphs());
    }

    @Override
    public void recordAction() throws InvalidActionTakenException {
        if (this.cancel) {
            String errorMessage = this.validateActionRules(this.getActionRequestService().findAllPendingRequests(this.getDocumentId()));
            if (!StringUtils.isEmpty((String)errorMessage)) {
                throw new InvalidActionTakenException(errorMessage);
            }
            new CancelAction(this, ActionType.RECALL, this.routeHeader, this.getPrincipal(), this.annotation){

                @Override
                public boolean isActionCompatibleRequest(List<ActionRequestValue> requests) {
                    return true;
                }

                @Override
                protected void markDocumentStatus() throws InvalidActionTakenException {
                    this.getRouteHeader().markDocumentRecalled();
                }
            }.recordAction();
        } else {
            super.recordAction();
            String oldStatus = this.getRouteHeader().getDocRouteStatus();
            this.getRouteHeader().markDocumentSaved();
            String newStatus = this.getRouteHeader().getDocRouteStatus();
            this.notifyStatusChange(newStatus, oldStatus);
            DocumentRouteHeaderValue routeHeaderValue = KEWServiceLocator.getRouteHeaderService().saveRouteHeader(this.routeHeader);
            this.setRouteHeader(routeHeaderValue);
        }
        ActionTakenValue last = RecallAction.getLastActionTaken(this.getDocumentId());
        if (last != null) {
            this.notifyAfterActionTaken(last);
        }
    }

    protected static ActionTakenValue getLastActionTaken(String docId) {
        ActionTakenValue last = null;
        Collection<ActionTakenValue> actionsTaken = KEWServiceLocator.getActionTakenService().findByDocumentId(docId);
        for (ActionTakenValue at : actionsTaken) {
            if (last != null && !at.getActionDate().after(last.getActionDate())) continue;
            last = at;
        }
        return last;
    }
}

