/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ken.core;

import org.kuali.rice.ken.dao.NotificationDao;
import org.kuali.rice.ken.api.service.KENAPIService;
import org.kuali.rice.ken.dao.NotificationMessegeDeliveryDao;
import org.kuali.rice.ken.service.NotificationAuthorizationService;
import org.kuali.rice.ken.service.NotificationChannelService;
import org.kuali.rice.ken.service.NotificationContentTypeService;
import org.kuali.rice.ken.service.NotificationMessageContentService;
import org.kuali.rice.ken.service.NotificationMessageDeliveryAutoRemovalService;
import org.kuali.rice.ken.service.NotificationMessageDeliveryResolverService;
import org.kuali.rice.ken.service.NotificationMessageDeliveryService;
import org.kuali.rice.ken.service.NotificationRecipientService;
import org.kuali.rice.ken.service.NotificationService;
import org.kuali.rice.ken.service.NotificationWorkflowDocumentService;
import org.kuali.rice.ken.service.UserPreferenceService;
import org.quartz.Scheduler;
import org.springframework.beans.factory.BeanFactory;

/**
 * NotificationServiceLocator backed by a Spring Bean Factory - responsible for returning instances of services instantiated by the Spring context loader.
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class SpringNotificationServiceLocator implements NotificationServiceLocator {
    // Spring bean names
    private static final String KENAPI_SERVICE = "kenApiService";
    private static final String NOTIFICATION_SERVICE = "notificationService";
    private static final String NOTIFICATION_CONTENT_TYPE_SERVICE = "notificationContentTypeService";
    private static final String MESSAGE_CONTENT_SERVICE = "messageContentService";
    private static final String NOTIFICATION_DAO = "kenNotificationDao";
    private static final String NOTIFICATION_MESSEGE_DELIVERY_DAO = "kenNotificationMessegeDeliveryDao";
    
    private static final String NOTIFICATION_AUTHORIZATION_SERVICE = "notificationAuthorizationService";
    private static final String NOTIFICATION_WORKFLOW_DOCUMENT_SERVICE = "notificationWorkflowDocumentService";
    private static final String NOTIFICATION_MESSAGE_DELIVERY_DISPATCH_SERVICE = "notificationMessageDeliveryDispatchService";
    private static final String NOTIFICATION_MESSAGE_DELIVERY_RESOLVER_SERVICE = "notificationMessageDeliveryResolverService";
    private static final String NOTIFICATION_MESSAGE_DELIVERY_AUTOREMOVAL_SERVICE = "notificationMessageDeliveryAutoRemovalService";
    private static final String NOTIFICATION_RECIPIENT_SERVICE = "notificationRecipientService";
    private static final String NOTIFICATION_MESSAGE_DELIVERY_SERVICE = "notificationMessageDeliveryService";
    private static final String NOTIFICATION_MESSAGE_DELIVERER_REGISTRY_SERVICE = "notificationMessageDelivererRegistryService";
    private static final String USER_PREFERENCE_SERVICE = "userPreferenceService";
    private static final String NOTIFICATION_CHANNEL_SERVICE = "notificationChannelService";
    private static final String NOTIFICATION_EMAIL_SERVICE = "notificationEmailService";
    private static final String NOTIFICATION_CONFIG = "notificationConfig";
    private static final String NOTIFICATION_SCHEDULER = "notificationScheduler";

    private BeanFactory beanFactory;

    public SpringNotificationServiceLocator(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }
    
    @Override
    public KENAPIService getKENAPIService() {
        return (KENAPIService) beanFactory.getBean(KENAPI_SERVICE);
    }


    @Override
    public NotificationService getNotificationService() {
        return (NotificationService) beanFactory.getBean(NOTIFICATION_SERVICE);
    }

    @Override
    public NotificationContentTypeService getNotificationContentTypeService() {
        return (NotificationContentTypeService) beanFactory.getBean(NOTIFICATION_CONTENT_TYPE_SERVICE);
    }

    @Override
    public NotificationMessageContentService getNotificationMessageContentService() {
        return (NotificationMessageContentService) beanFactory.getBean(MESSAGE_CONTENT_SERVICE);
    }

    public NotificationDao getNotificationDao() {
        return (NotificationDao) beanFactory.getBean(NOTIFICATION_DAO);
    }
    
    public NotificationMessegeDeliveryDao getNotificationMessegDeliveryDao() {
        return (NotificationMessegeDeliveryDao) beanFactory.getBean(NOTIFICATION_MESSEGE_DELIVERY_DAO);
    }

    @Override
    public NotificationAuthorizationService getNotificationAuthorizationService() {
        return (NotificationAuthorizationService) beanFactory.getBean(NOTIFICATION_AUTHORIZATION_SERVICE);
    }

    @Override
    public NotificationWorkflowDocumentService getNotificationWorkflowDocumentService() {
        return (NotificationWorkflowDocumentService) beanFactory.getBean(NOTIFICATION_WORKFLOW_DOCUMENT_SERVICE);
    }

    @Override
    public NotificationMessageDeliveryAutoRemovalService getNotificationMessageDeliveryAutoRemovalService() {
        return (NotificationMessageDeliveryAutoRemovalService) beanFactory.getBean(NOTIFICATION_MESSAGE_DELIVERY_AUTOREMOVAL_SERVICE);
    }

    @Override
    public NotificationMessageDeliveryResolverService getNotificationMessageDeliveryResolverService() {
        return (NotificationMessageDeliveryResolverService) beanFactory.getBean(NOTIFICATION_MESSAGE_DELIVERY_RESOLVER_SERVICE);
    }

    @Override
    public NotificationRecipientService getNotificationRecipientService() {
        return (NotificationRecipientService) beanFactory.getBean(NOTIFICATION_RECIPIENT_SERVICE);
    }

    @Override
    public NotificationMessageDeliveryService getNotificationMessageDeliveryService() {
        return (NotificationMessageDeliveryService) beanFactory.getBean(NOTIFICATION_MESSAGE_DELIVERY_SERVICE);
    }

    @Override
    public UserPreferenceService getUserPreferenceService() {
        return (UserPreferenceService) beanFactory.getBean(USER_PREFERENCE_SERVICE);
    }

    @Override
    public NotificationChannelService getNotificationChannelService() {
        return (NotificationChannelService) beanFactory.getBean(NOTIFICATION_CHANNEL_SERVICE);
    }

    @Override
    public Scheduler getScheduler() {
        return (Scheduler) beanFactory.getBean(NOTIFICATION_SCHEDULER);
    }
}
