/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ken.service;


/**
 * This class is responsible for the job that will actually resolve which recipients receive a notification for specific endpoints.
 * This service will be responsible for creating NotificationDeliveryMessage object instances to be used by a later process that actually 
 * delivers the messages.
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface NotificationMessageDeliveryResolverService {
    /**
     * This service method is responsible for retrieving all unprocessed notifications that have sendDateTimes either equal to or before the 
     * current time, and resolving their recipient lists so that proper NotificationMessageDelivery records can be created for them.  
     * This service is to be run periodically in a separate thread, as a daemon process.
     * @return int the number of resolved messages
     */
    public ProcessingResult resolveNotificationMessageDeliveries();
}
