/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.docsearch.dao;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;

public interface SearchableAttributeDAO {

	public List<String> getSearchableAttributeStringValuesByKey(
			String documentId, String key);

	public List<Timestamp> getSearchableAttributeDateTimeValuesByKey(
			String documentId, String key);

	public List<BigDecimal> getSearchableAttributeFloatValuesByKey(
			String documentId, String key);

	public List<Long> getSearchableAttributeLongValuesByKey(String documentId,
			String key);
}
