/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine.node;

import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.RouteHelper;

import java.util.ArrayList;
import java.util.List;


/**
 * A simple {@link SplitNode} implementation which always splits to all branches that are defined for the split.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class SimpleSplitNode implements SplitNode {

    @Override
    public SplitResult process(RouteContext routeContext, RouteHelper routeHelper) throws Exception {
    	List<String> branchNames = new ArrayList<String>();
        for (RouteNode routeNode : routeContext.getNodeInstance().getRouteNode().getNextNodes())
        {
            branchNames.add(routeNode.getBranch().getName());
        }
        return new SplitResult(branchNames);
    }
    
}
