/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.rule;

import org.kuali.rice.kew.api.validation.RuleValidationContext;
import org.kuali.rice.kew.api.validation.ValidationResults;

/**
 * A simple interface for handling validation of rules.  Validation results are returned in a
 * ValidationResults object which consists of a series of error messages regarding the
 * rule.  The user who is adding or editing the rule is passed to validate as well as the
 * rule to be validated.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface RuleValidationAttribute {
	
	/**
	 * Validates the rule within the given RuleValidationContext.
	 * 
	 * @return a ValidationResults object representing the results of the validation, if this is
	 * empty or <code>null</code> this signifies that validation was successful.
	 */
	public ValidationResults validate(RuleValidationContext validationContext);

}
